@php
    $title = labels('front_messages.about_us', 'About Us');
@endphp

<style>
/* IMAGE STICKY ON DESKTOP */
.about-sticky {
    position: sticky;
    top: 100px;
    align-self: flex-start;
    height: fit-content;
}

.scroll-box {
    height: 80vh;
    overflow-y: scroll;
    padding-right: 10px;

    scrollbar-width: none;
    -ms-overflow-style: none;
}

.scroll-box::-webkit-scrollbar {
    display: none;
}

/* Mobile reset */
@media (max-width: 767px) {
    .about-sticky {
        position: static;
    }
    .scroll-box {
        height: auto;
        overflow: visible;
    }
}
</style>

<div>
    <x-utility.breadcrumbs.breadcrumbOne :breadcrumb="$title" />

    <div id="page-content" class="destination-section section pt-0">
        <div class="container">

            <!-- IMPORTANT: remove align-items-start -->
            <div class="row">

                <!-- Sticky Image -->
                 {{--
                <div class="col-12 col-sm-12 col-md-4 about-sticky">
                    <div class="about-images mb-4 mb-md-0">
                        <img class="rounded-0 blur-up lazyload"
                             data-src="{{ asset('storage/' . $settings->logo) }}"
                             src="{{ asset('storage/' . $settings->logo) }}"
                             alt="about" width="700" height="80vh" />
                    </div>
                </div>
                --}}

                <!-- Scrollable Text -->
                <div class="col-12 col-sm-12 col-md-12">
                    <div class="about-details px-50 py-5 scroll-box">
                        <!-- <h2 class="fs-4 mb-4">{{ labels('front_messages.about_us', 'About Us') }}</h2> -->
                        <p>{!! nl2br($about_us) !!}</p>

                        <a href="/products" wire:navigate class="btn btn-lg mt-md-2">
                            {{ labels('front_messages.explore_now', 'Explore Now') }}
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="service-section section section-color-light">
        <x-utility.others.serviceSection />
    </div>
</div>
