@php
    use App\Services\StoreService;
    use App\Services\TranslationService;
    $store_settings = app(StoreService::class)->getStoreSettings();
    $language_code = app(TranslationService::class)->getLanguageCode();
    $category_section_title = $store_settings['category_section_title'] ?? 'Categories';
@endphp

<style>
    /* Apply line-height: 1 to all relevant text elements */
    #page-content h2,
    #page-content h4,
    #page-content p,
    #page-content .ctg-title,
    #page-content .ctg-des,
    #page-content .category-title,
    #page-content .btn,
    #page-content .button-text,
    #page-content a {
        line-height: 1;
    }

    /* Swiper container adjustments */
    .homeSwiper {
        width: 100%;
        height: 100%;
        border-radius: 16px;
        position: relative;
    }

    /* Each slide image */
    .homeSwiper .slider-image {
        width: 100%;
        height: 570px;
        /* Adjust height as needed */
        object-fit: cover;
        border-radius: 0px;
        transition: transform 0.4s ease;
    }

    /* Hover zoom effect */
    /* .homeSwiper .swiper-slide:hover .slider-image {
        transform: scale(1.03);
    } */

    /* Pagination bullets */
    .swiper-pagination-bullet {
        background: #070707ff;
        opacity: 0.6;
        transition: all 0.3s;
    }

    .swiper-pagination-bullet-active {
        background: #28a745;
        /* green active bullet */
        opacity: 1;
    }

    /* Navigation buttons */
    .swiper-button-next,
    .swiper-button-prev {
        color: #fff;
        background: #28a745(0, 0, 0, 0.3);
        border-radius: 50%;
        width: 60px;
        height: 60px;
    }

    .swiper-button-prev {
        margin-left: 20px;
    }

    .swiper-button-next {
        margin-right: 20px;
    }

    .swiper-button-next::after,
    .swiper-button-prev::after {
        font-size: 28px;
    }

    .swiper-button-next:hover,
    .swiper-button-prev:hover {
        background: rgba(0, 0, 0, 0.5);
    }

    /* Responsive height */
    @media (max-width: 767px) {
        .homeSwiper .slider-image {
            height: 250px;
        }

        .homeSwiper {
            height: 250px;
        }
    }
</style>

<style>
    .shop-section {

        text-align: center;
        margin-top: 40px;
    }

    .shop-section h2 {
        font-size: 1.8rem;
        font-weight: 600;
        margin-bottom: 20px;
        color: #333;
    }

    .category-tabs {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin-bottom: 25px;
        flex-wrap: wrap;
    }

    .category-tab {
        padding: 8px 20px;
        border: 1px solid #ccc;
        border-radius: 4px;
        background: #fff;
        cursor: pointer;
        font-size: 15px;
        transition: 0.2s;
    }

    .category-tab.active,
    .category-tab:hover {
        background-color: #008037;
        color: #fff;
        border-color: #008037;
    }

    .product-card {
        position: relative;
        border: 1px solid #e0e0e0;
        border-radius: 6px;
        overflow: hidden;
        background: #fff;
        transition: 0.3s;
        width: 100%;
        max-width: 250px;
    }

    .product-card:hover {
        border-color: #008037;
    }

    .product-card img {
        width: 100%;
        height: 200px;
        object-fit: cover;
        display: block;
    }

    .new-badge {
        position: absolute;
        top: 10px;
        left: 10px;
        background-color: #008037;
        color: #fff;
        font-size: 13px;
        padding: 3px 8px;
        border-radius: 3px;
        font-weight: 600;
    }

    .product-info {
        padding: 10px;
        text-align: left;
    }

    .product-info h5 {
        font-size: 15px;
        font-weight: 500;
        margin: 5px 0;
        color: #333;
    }

    .product-info p {
        font-size: 14px;
        color: #777;
        margin: 0;
    }

    .product-section {
        padding: 40px 20px;
    }

    .product-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 24px;
        justify-content: center;
    }

    .product-card {
        background: #fff;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
    }

    /* .product-image {
        position: relative;
        background: #f7f7f7;
        height: 240px;
        display: flex;
        justify-content: center;
        align-items: center;
    } */

    /* .product-image img {
        max-width: 100%;
        max-height: 100%;
        object-fit: contain;
    } */

    .icons {
        position: absolute;
        top: 10px;
        right: 10px;
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .icons button {
        background: white;
        border: none;
        border-radius: 50%;
        width: 32px;
        height: 32px;
        cursor: pointer;
        font-size: 14px;
        box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
    }

    .product-info {
        text-align: center;
        padding: 16px;
    }

    .brand {
        font-size: 12px;
        color: #888;
        text-transform: uppercase;
        margin-bottom: 6px;
    }

    .title {
        font-size: 15px;
        color: #222;
        margin-bottom: 10px;
        min-height: 40px;
    }

    .price {
        margin-bottom: 8px;
    }

    .price .old {
        color: #999;
        text-decoration: line-through;
        margin-right: 6px;
    }

    .price .new {
        color: #008037;
        font-weight: 600;
    }

    .type {
        font-size: 13px;
        color: #777;
        margin-bottom: 8px;
    }

    .rating span {
        font-size: 16px;
        color: #ccc;
    }

    .add-to-cart {
        width: 100%;
        background: #008037;
        color: #fff;
        border: none;
        border-radius: 6px;
        padding: 10px 0;
        margin-top: 12px;
        cursor: pointer;
        font-weight: 500;
        transition: background 0.3s ease;
    }

    .add-to-cart:hover {
        background: #00692f;
    }
</style>
<style>
    .image-divider {
        width: 100%;
        overflow: hidden;
    }

    .image-divider img {
        width: 100%;
        height: 140px;
        object-fit: contain;
    }
</style>

<style>
    body {
        font-family: "Poppins", sans-serif;
        background: #fff;
        color: #333;
        margin: 0;
        padding: 0;
    }

    .product-section {
        padding: 40px 20px;
        max-width: 1200px;
        margin: auto;
    }

    .product-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
        gap: 24px;
        justify-content: center;
    }

    .product-card {
        background: #fff;
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.15);
    }

    /* .product-image {
        position: relative;
        background: #f7f7f7;
        height: 240px;
        display: flex;
        justify-content: center;
        align-items: center;
    } */

    /* .product-image img {
        max-width: 100%;
        max-height: 100%;
        object-fit: contain;
    } */

    .icons {
        position: absolute;
        top: 10px;
        right: 10px;
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .icons button {
        background: white;
        border: none;
        border-radius: 50%;
        width: 32px;
        height: 32px;
        cursor: pointer;
        font-size: 14px;
        box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
    }

    .product-info {
        text-align: center;
        padding: 16px;
    }

    .brand {
        font-size: 12px;
        color: #888;
        text-transform: uppercase;
        margin-bottom: 6px;
    }

    .title {
        font-size: 15px;
        color: #222;
        margin-bottom: 10px;
        min-height: 40px;
    }

    .price {
        margin-bottom: 8px;
    }

    .price .old {
        color: #999;
        text-decoration: line-through;
        margin-right: 6px;
    }

    .price .new {
        color: #008037;
        font-weight: 600;
    }

    .type {
        font-size: 13px;
        color: #777;
        margin-bottom: 8px;
    }

    .rating span {
        font-size: 16px;
        color: #ccc;
    }

    .add-to-cart {
        width: 100%;
        background: #008037;
        color: #fff;
        border: none;
        border-radius: 6px;
        padding: 10px 0;
        margin-top: 12px;
        cursor: pointer;
        font-weight: 500;
        transition: background 0.3s ease;
    }

    .add-to-cart:hover {
        background: #00692f;
    }

    .brandSwiper .swiper-wrapper {
        transition-timing-function: linear !important;
    }

    .brand-section .brand-box {
        width: 130px;
        height: 130px;
        transition: all 0.3s ease;
        border: 1px solid #eee;
    }

    .brand-section .brand-box:hover {
        transform: translateY(-5px);
        border-color: #008037;
    }

    .brand-section .brand-image {
        width: 100%;
        height: 100px;
        overflow: hidden;
    }

    .brand-section .brand-image img {
        max-width: 100%;
        max-height: 100%;
        width: auto;
        height: auto;
        object-fit: contain;
        transition: transform 0.3s ease;
    }

    .brand-section .brand-box:hover img {
        transform: scale(1.1);
    }

    @media (max-width: 576px) {
        .brand-section .brand-box {
            width: 110px;
            height: 110px;
        }

        .brand-section .brand-image {
            height: 60px;
        }
    }
</style>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

<div wire:ignore id="page-content" class="index-demo1">
    {{-- <section class="slideshow slideshow-wrapper slideshow-medium">
        <div class="swiper mySwiper home-mySwiper">
            <div class="swiper-wrapper">
                @foreach ($sliders as $slider)
                <div class="swiper-slide slideshow-wrap">
                    @if ($slider['type'] !== 'default')
                    <a @if ($slider['type'] !=='slider_url' ) wire:navigate @endif href="{{ $slider['link'] }}"
                        class="slider-link" data-link="{{ $slider['link'] }}"
                        target="{{ $slider['type'] == 'slider_url' ? '_blank' : '' }}">
                        <img class="rounded-4 blur-up lazyload" data-src="{{ $slider['image'] }}"
                            src="{{ $slider['image'] }}" alt="slideshow" title="" />
                    </a>
                    @else
                    <img class="rounded-4 blur-up lazyload" data-src="{{ $slider['image'] }}"
                        src="{{ $slider['image'] }}" alt="slideshow" title="" />
                    @endif
                </div>
                @endforeach
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </section> --}}
    <section class="slideshow slideshow-wrapper slideshow-medium ">
        <div class="swiper homeSwiper rounded-4 overflow-hidden">
            <div class="swiper-wrapper">
                @foreach ($sliders as $slider)
                    <div class="swiper-slide slideshow-wrap">
                        @if ($slider['type'] !== 'default')
                            <a @if ($slider['type'] !== 'slider_url') wire:navigate @endif href="{{ $slider['link'] }}"
                                class="slider-link d-block" data-link="{{ $slider['link'] }}"
                                target="{{ $slider['type'] == 'slider_url' ? '_blank' : '' }}">
                                <img class="slider-image rounded-4 blur-up lazyload w-100" data-src="{{ $slider['image'] }}"
                                    src="{{ $slider['image'] }}" alt="slideshow" title="" />
                            </a>
                        @else
                            <img class="slider-image rounded-4 blur-up lazyload w-100" data-src="{{ $slider['image'] }}"
                                src="{{ $slider['image'] }}" alt="slideshow" title="" />
                        @endif
                    </div>
                @endforeach
            </div>

            <!-- Swiper Pagination & Navigation -->
            <div class="swiper-pagination"></div>
            {{-- <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div> --}}
        </div>
    </section>

    <!--Popular Categories-->
    @php
        $categories = $categories['categories'];
    @endphp
    @if (is_array($categories) && count($categories) >= 1)
        <section class="section collection-slider py-4">
            <div class="section-header style2  flex-column  align-items-center text-center">
                <div class="section-header-left text-center">
                    @if ($store_settings['category_section_title'] != null)
                            <h2>
                                {{ is_array($category_section_title)
                        ? $category_section_title[$language_code] ?? ($category_section_title['en'] ?? reset($category_section_title))
                        : $category_section_title }}
                            </h2>
                    @else
                        <h2>
                            {{ labels('front_messages.popular_categories', 'Popular Categories') }}
                        </h2>
                    @endif
                    <span>
                        {{ labels('front_messages.explore_categories', 'Explore top picks in our Categories!') }}
                    </span>
                </div>
            </div>

            <x-utility.categories.sliders.sliderThree :$categories />
            {{--
            <div class="row justify-content-center mt-4">

                <a wire:navigate href="{{ customUrl('categories') }}" class="btn btn-primary  mt-2 "
                    style="padding: 12px 24px; font-size: 18px;">

                    {{ labels('front_messages.view_more', ' View More') }}

                </a>

            </div>
            --}}

        </section>
    @endif

    @if (is_array($categories_section) && count($categories_section) >= 1)
        @foreach ($categories_section as $category_section)
            <section class="section collection-slider py-4">
                <div class="container-fluid">
                    <div class="section-header style2 d-flex flex-column align-items-center text-center">
                        <div class="section-header-left text-center">
                            <h2>{{ $category_section->title }}</h2>
                            <span>{{ labels('front_messages.explore_categories', 'Explore top picks in our Categories!') }}
                            </span>
                        </div>
                        {{-- <div class="section-header-right text-start text-sm-end mt-sm-0">
                            <a wire:navigate href="{{ customUrl('categories') }}"
                                class="d-flex align-items-center view_more_icon arrow_icon">
                                <i class="anm anm-arrow-alt-right hdr-icon icon"></i>
                            </a>
                        </div> --}}
                    </div>
                    @php
                        $categories = $category_section->categories_detail;
                    @endphp
                    <x-utility.categories.sliders.sliderThree :$categories />
                    {{-- <div class="section-header-right text-start text-sm-end mt-sm-0">
                        <a wire:navigate href="{{ customUrl('categories') }}"
                            class="d-flex align-items-center view_more_icon arrow_icon">
                            <i class="anm anm-arrow-alt-right hdr-icon icon"></i>
                        </a>
                    </div> --}}
                    <a wire:navigate href="{{ customUrl('categories') }}" class="btn btn-primary  mt-2"
                        style="padding: 12px 24px; font-size: 18px;">

                        {{ labels('front_messages.view_more', ' View More') }}

                    </a>
                </div>
            </section>
        @endforeach
    @endif
    <div>


    </div>
    <!--Popular brands-->
    @if (is_array($brands['brands']) && count($brands['brands']) >= 1)
        <section class="section collection-slider py-4">
            <div class="container">
                <div class="section-header d-flex flex-column align-items-center text-center">
                    <div class="section-header-left">
                        <h2>{{ labels('front_messages.popular_brands', 'Tranding Brands') }}</h2>
                        <span>{{ labels('front_messages.explore_brands', 'Explore top picks in our Brands!') }}</span>
                    </div>
                </div>
                <div class="brand-section text-center container pt-4">

                    <div class="swiper brandSwiper">
                        <div class="swiper-wrapper">

                            @foreach (collect($brands['brands'])->take(8) as $brand)
                                <div class="swiper-slide d-flex justify-content-center py-3">
                                    <a wire:navigate href="{{ customUrl('products/?brand=' . $brand['brand_slug']) }}"
                                        class="brand-box d-flex flex-column align-items-center justify-content-center text-decoration-none p-2 rounded-4 shadow-sm bg-white">
                                        <div class="brand-image d-flex align-items-center justify-content-center">
                                            <img class="blur-up lazyload" data-src="{{ $brand['brand_img'] }}"
                                                src="{{ $brand['brand_img'] }}" alt="{!! $brand['brand_name'] !!}">
                                        </div>
                                    </a>
                                </div>
                            @endforeach

                        </div>

                    </div>



                </div>

                {{-- <div class="swiper category-mySwiper">
                    <div class="swiper-wrapper">
                        @foreach ($brands['brands'] as $brand)
                        <div class="swiper-slide slider-brand zoomscal-hov rounded-4">
                            <a wire:navigate href="{{ customUrl('products/?brand=' . $brand['brand_slug']) }}"
                                class="category-link clr-none bg-body brand-box slider-link"
                                data-link="{{ customUrl('products/?brand=' . $brand['brand_slug']) }}">
                                <div class="zoom-scal zoom-scal-nopb img-box-h140">
                                    <img class="blur-up lazyload  object-fit-contain" width="100" height="100"
                                        data-src="{{ $brand['brand_img'] }}" src="{{ $brand['brand_img'] }}"
                                        alt="{!! $brand['brand_name'] !!}" title="" />
                                </div>
                                @if (($store_settings['brand_style'] ?? null) == 'brands_style_1')
                                <div class="details text-center bg-body">
                                    <h4 class="category-title mb-0 fs-6 fw-600 text-capitalize">
                                        {!! $brand['brand_name'] !!}
                                    </h4>
                                </div>
                                @endif
                            </a>
                        </div>
                        @endforeach
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                --}}

                {{--
                <div class="brand-section text-center container">
                    <div class="row justify-content-center">
                        @foreach (collect($brands['brands'])->take(8) as $brand)
                        <div class="col-6 col-sm-4 col-md-3 col-lg-2-4 mb-4 d-flex justify-content-center">
                            <a wire:navigate href="{{ customUrl('products/?brand=' . $brand['brand_slug']) }}"
                                class="brand-box d-flex flex-column align-items-center justify-content-center text-decoration-none p-3 rounded-4 shadow-sm bg-white">
                                <div class="brand-image d-flex align-items-center justify-content-center mb-2">
                                    <img class="blur-up lazyload" data-src="{{ $brand['brand_img'] }}"
                                        src="{{ $brand['brand_img'] }}" alt="{!! $brand['brand_name'] !!}" />
                                </div>

                                @if (($store_settings['brand_style'] ?? null) == 'brands_style_1')
                                <h4 class="brand-title mb-0 fs-6 fw-600 text-capitalize text-dark">
                                    {!! $brand['brand_name'] !!}
                                </h4>
                                @endif
                            </a>

                        </div>
                        @endforeach
                    </div>
                    <a wire:navigate href="{{ customUrl('brands') }}" class="btn btn-primary  mt-2"
                        style="padding: 12px 24px; font-size: 18px;">

                        {{ labels('front_messages.view_more', ' View More') }}

                    </a>

                </div>
                --}}



                <script>
                    function initBrandSwiper() {
                        // Destroy existing instance if it exists
                        const existingSwiper = document.querySelector('.brandSwiper')?.swiper;
                        if (existingSwiper) {
                            existingSwiper.destroy(true, true);
                        }

                        // Initialize new Swiper
                        new Swiper(".brandSwiper", {
                            slidesPerView: 2,
                            spaceBetween: 20,
                            loop: true,
                            speed: 6000, // smooth continuous speed
                            autoplay: {
                                delay: 1, // ❗ NOT 0 (0 causes reset)
                                disableOnInteraction: false,
                                pauseOnMouseEnter: false
                            },
                            allowTouchMove: false, // ❗ prevents reflow pause
                            freeMode: false, // ❗ disable freeMode
                            watchSlidesProgress: true, // smoother rendering
                            breakpoints: {
                                576: {
                                    slidesPerView: 3
                                },
                                768: {
                                    slidesPerView: 4
                                },
                                992: {
                                    slidesPerView: 5
                                },
                                1200: {
                                    slidesPerView: 6
                                }
                            }
                        });
                    }

                    // Initialize on page load
                    document.addEventListener("DOMContentLoaded", initBrandSwiper);

                    // Initialize on Livewire navigation
                    document.addEventListener("livewire:navigated", initBrandSwiper);
                </script>
            </div>
        </section>
    @endif

    <!--Customer Reviews-->

    @if (isset($ratings) && !empty($ratings) && count($ratings) >= 1)
        <section class="section testimonial-slider style1  py-4">
            <div class="container-fluid index-demo3">
                <div class="section-header justify-content-between align-items-center mb-4">

                    <div class="section-header style2 flex-column align-items-center text-center">
                        <div class="section-header-left">
                            <h2>{{ labels('front_messages.customer_reviews', 'Customer Reviews') }}</h2>
                            <span>{{ labels('front_messages.shop_trusted_tiles', 'Shop trusted products with the best customer reviews.') }}</span>
                        </div>
                    </div>
                    <!-- Swiper Navigation -->
                    <!-- <div class="d-flex gap-2">
                                             <div class="swiper-button-prev-reviews btn btn-outline-secondary rounded-1 p-0 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px; border-color: #ddd;">
                                                <ion-icon name="chevron-back-outline"></ion-icon>
                                            </div>
                                            <div class="swiper-button-next-reviews btn btn-outline-secondary rounded-1 p-0 d-flex align-items-center justify-content-center" style="width: 40px; height: 40px; border-color: #ddd;">
                                                <ion-icon name="chevron-forward-outline"></ion-icon>
                                            </div>
                                        </div> -->
                </div>

                <div class="testimonial-wraper">
                    <div class="swiper customer-reviews-swiper">
                        <div class="swiper-wrapper">
                            @foreach ($ratings as $rating)
                                <div class="swiper-slide h-auto">
                                    <div class="card h-100 border-1 border-warning rounded-4 p-4 shadow-sm"
                                        style="border-color: #f4a51c !important;">
                                        @php
                                            $userName = $rating['user_name'] ?? 'User';
                                            $userProfile = $rating['user_profile'] ?? app(\App\Services\MediaService::class)->getImageUrl('no-user-img.jpeg', '', '', 'image', 'NO_USER_IMAGE');
                                        @endphp
                                        <div class="d-flex align-items-center mb-3 h-50">
                                            <div class="flex-shrink-0">
                                                <img src="{{ $userProfile }}" class="rounded-circle object-fit-cover"
                                                    width="100" height="100" alt="{{ $userName }}">
                                            </div>
                                            <div class="ms-3">
                                                <h5 class="mb-0 fs-6 fw-bold text-dark">{{ $userName }}</h5>

                                            </div>
                                        </div>
                                        <div class="mb-3 text-warning">
                                            @for ($i = 0; $i < 5; $i++)
                                                @if ($i < $rating['rating'])
                                                    <ion-icon name="star"></ion-icon>
                                                @else
                                                    <ion-icon name="star-outline"></ion-icon>
                                                @endif
                                            @endfor
                                        </div>
                                        <p class="card-text text-muted" style="font-size: 0.95rem; line-height: 1.5;">
                                            {{ Str::limit($rating['comment'], 300) }}
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <script>
            function initReviewsSwiper() {
                // Destroy existing instance if it exists
                const existingSwiper = document.querySelector('.customer-reviews-swiper')?.swiper;
                if (existingSwiper) {
                    existingSwiper.destroy(true, true);
                }

                // Initialize new Swiper
                new Swiper('.customer-reviews-swiper', {
                    slidesPerView: 1,
                    spaceBetween: 20,
                    loop: true,
                    autoplay: {
                        delay: 3000,
                        disableOnInteraction: false,
                    },
                    navigation: {
                        nextEl: '.swiper-button-next-reviews',
                        prevEl: '.swiper-button-prev-reviews',
                    },
                    breakpoints: {
                        640: {
                            slidesPerView: 1,
                            spaceBetween: 20,
                        },
                        768: {
                            slidesPerView: 2,
                            spaceBetween: 20,
                        },
                        1024: {
                            slidesPerView: 3,
                            spaceBetween: 24,
                        },
                    }
                });
            }

            // Initialize on page load
            document.addEventListener('DOMContentLoaded', initReviewsSwiper);

            // Initialize on Livewire navigation
            document.addEventListener('livewire:navigated', initReviewsSwiper);
        </script>
    @endif
    <!--End Customer Reviews-->


    {{-- @if (!empty($offers) && isset($offers[0]['banner_image']) && !empty($offers[0]['banner_image']))
    <section class="image-divider container">
        <img src="{{ $offers[0]['banner_image'] }}" alt="Offer Banner">
    </section>
    @endif
    --}}
    <!-- shop by category tab -->
    {{--
    <div class="shop-section container">
        <div class="section-header style2 d-flex flex-column align-items-center text-center">
            <div class="section-header-left">

                <h2>{{ labels('front_messages.shop_by_category', 'Shop By Category') }}</h2>
                <span>{{labels('front_messages.explore_brands', 'Explore top picks in our Brands!')}}</span>
            </div>
        </div>
        <div class="category-tabs" id="room-tabs">
            @foreach ($categories as $category)
            <button class="category-tab room-tab" data-slug="{{ $category->slug }}">
                {{ $category->name }}
            </button>
            @endforeach
        </div>

        <div id="room-products-container"></div>

        <div class="text-center mt-4">
            <a id="view-all-products-link"
                href="{{ !empty($categories) && isset($categories[0]) ? customUrl('categories/' . $categories[0]->slug . '/products') : '#' }}"
                class="btn btn-primary " style="padding: 12px 24px; font-size: 18px;">
                View All Products
            </a>
        </div>


    </div>
    --}}
    <!-- end shop by category tab -->

    <div class="section">
        <div class="container-fluid">
            <div class="section-header style2 d-flex flex-column align-items-center text-center">
                <div class="section-header-left">
                    <h2>{{ labels('front_messages.best_selling_products', 'Top-Selling Products') }}</h2>
                    <span>{{ labels('front_messages.these_items_are_loved_by_thousands_of_customers', 'These items are loved by thousands of customers!') }}</span>
                </div>
            </div>

            <div class="row" id="productGrid"></div>
        </div>
    </div>

    <!--Products With Tabs-->
    @foreach ($sections as $count_key => $row)
        @if (!empty($row->product_details) && count((array) $row->product_details) > 0)
            @if ($row->style == 'style_1')
                <section class="section product-slider tab-slider-product">
                    <div class="container-fluid">
                        <x-utility.section_header.sectionHeaderOne :title="$row" />
                        <div
                            class="swiper style1-mySwiper gp15 arwOut5 hov-arrow grid-products {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }}">
                            <div class="swiper-wrapper">
                                @foreach ($row->product_details as $details)
                                    <div class="swiper-slide">
                                        @php
                                            $component = getProductDisplayComponent($store_settings);
                                            $details = (object) $details;
                                        @endphp
                                        <x-dynamic-component :component="$component" :details="$details" />
                                    </div>
                                @endforeach
                            </div>
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                    </div>
                </section>
            @endif
            @if ($row->style == 'style_2')
                <section class="section product-banner-slider pt-0">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-12 col-sm-12 col-md-12 col-lg-9">
                                <div
                                    class="grid-products swiper style2-mySwiper gp15 arwOut5 hov-arrow circle-arrow arrow.lr-0 {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }}">
                                    <div class="swiper-wrapper">
                                        @foreach ($row->product_details as $details)
                                            <div class="swiper-slide">
                                                @php
                                                    $component = getProductDisplayComponent($store_settings);
                                                    $details = (object) $details;
                                                @endphp
                                                <x-dynamic-component :component="$component" :details="$details" />
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="swiper-button-next"></div>
                                    <div class="swiper-button-prev"></div>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-12 col-lg-3 mt-4 mt-lg-0">
                                <div class="ctg-bnr-wrap two position-relative h-100">
                                    <div class="ctg-image ratio ratio-1x1 h-100">
                                        <img class="blur-up lazyload object-fit-cover" data-src="{{ $row->banner_image }}"
                                            src="{{ $row->banner_image }}" alt="{{ $row->title }}" width="309" height="483" />
                                    </div>
                                    <div class="ctg-content text-white d-flex-justify-center flex-nowrap flex-column h-100">
                                        <h2 class="ctg-title text-white m-0">{{ $row->title }}</h2>
                                        <span class="ctg-des mt-1 mb-4">{{ $row->short_description }}</span>
                                        <a wire:navigate
                                            href="{{ customUrl('section/' . $row->slug . '/' . $row->id . '/' . ($row->product_type == 'custom_combo_products' ? 'combo-' : '') . 'products') }}"
                                            class="btn btn-secondary explore-btn button-style">
                                            <span
                                                class="text button-text">{{ labels('front_messages.shop_now', 'Shop Now') }}</span>
                                            <span class="button-icon button-icon-right"><ion-icon
                                                    name="arrow-forward-outline"></ion-icon></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            @endif
            @if ($row->style == 'style_3')
                    <!--Products Slider-->
                    <section class="section product-banner-slider">
                        <div class="container-fluid">
                            <div class="row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-3 mb-4 mb-lg-0">
                                    <div class="ctg-bnr-wrap one position-relative h-100">
                                        <div class="ctg-image ratio ratio-1x1 h-100">
                                            <img class="blur-up lazyload object-fit-cover" data-src="{{ $row->banner_image }}"
                                                src="{{ $row->banner_image }}" alt="{{ $row->title }}" width="390" height="483" />
                                        </div>
                                        <div class="ctg-content text-white d-flex-justify-center flex-nowrap flex-column h-100">
                                            <h2 class="ctg-title text-white m-0">{{ $row->title }}</h2>
                                            <span class="ctg-des mt-3 mb-4">{{ $row->short_description }}</span>
                                            <a wire:navigate
                                                href="{{ customUrl('section/' . $row->slug . '/' . $row->id . '/' . ($row->product_type == 'custom_combo_products' ? 'combo-' : '') . 'products') }}"
                                                class="btn btn-secondary explore-btn">
                                                {{ labels('front_messages.explore_now', 'Explore Now') }}
                                                <ion-icon class="ms-1" name="arrow-forward-outline"></ion-icon>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-12 col-lg-9">
                                    < Fontainebleau
                                        class="grid-products swiper style2-mySwiper gp15 arwOut5 hov-arrow circle-arrow arrowlr-0 {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }}">
                                        <div class="swiper-wrapper">
                                            @foreach ($row->product_details as $details)
                                                <div class="swiper-slide">
                                                    @php
                                                        $component = getProductDisplayComponent($store_settings);
                                                        $details = (object) $details;
                                                    @endphp
                                                    <x-dynamic-component :component="$component" :details="$details" />
                                                </div>
                                            @endforeach
                                        </div>
                                        <div class="swiper-button-next"></div>
                                        <div class="swiper-button-prev"></div>
                                </div>
                            </div>
                        </div>
                </div>
                </section>
            @endif
        @endif
    @endforeach

@if (
        $web_settings['support_mode'] == 1 ||
        $web_settings['shipping_mode'] == 1 ||
        $web_settings['safety_security_mode'] == 1 ||
        $web_settings['return_mode'] == 1
    )
    <section class="section service-section pb-0">
        <x-utility.others.serviceSection />
    </section>
@endif
</div>



<script>
    async function loadBestSellingProducts() {
        const productGrid = document.getElementById('productGrid');

        // Return early if container not found
        if (!productGrid) {
            return;
        }

        const storeId = 1; // change dynamically if needed

        try {
            // Show loading state
            productGrid.innerHTML = '<div class="col-12 text-center py-4">Loading products...</div>';

            const response = await fetch(`/api/top_selling_products?store_id=${storeId}`);

            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }

            const result = await response.json();

            if (!result.data || result.data.length === 0) {
                productGrid.innerHTML = "<span class='text-center py-4'>No products found.</span>";
                return;
            }

            // ✅ Show only first 8 products
            const products = result.data.slice(0, 8);

            let html = "";

            products.forEach(product => {
                const imageUrl = product.image ?
                    product.image :
                    "/placeholder.png"; // fallback

                html += `
                <div class="col-md-3 col-sm-6 mb-3 ">
                    <div class="card p-2 text-center ">

                        <!-- ✅ Product Image -->
                        <img src="${imageUrl}"
                             alt="${product.product_name}"
                             class="img-fluid mb-2"
                             style=" object-fit:contain;">

                        <!-- ✅ Product Name -->
                        <div class="product-name text-capitalize">
                        <a href="/products/${product.slug}" class="text-ellipsis" style="font-weight: bold;">${product.product_name}</a>
                        </div>

                        <!-- ✅ View Button -->
                          <div class="button-action mt-2 w-50 ">

                          <a href="/products/${product.slug}"
                           class=" button-style d-flex align-items-center btn btn-md" style="padding: 10px">
                           View Details
                        </a>

                        </div>

                    </div>
                </div>
                `;
            });

            productGrid.innerHTML = html;

        } catch (error) {
            console.error('Error loading best selling products:', error);
            productGrid.innerHTML = "<span class='text-center py-4'>Error loading products. Please try again.</span>";
        }
    }

    // Initialize on page load
    function initBestSellingOnReady() {
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', loadBestSellingProducts);
        } else {
            // DOM already loaded
            loadBestSellingProducts();
        }
    }

    initBestSellingOnReady();

    // Re-initialize when Livewire navigates (for SPA navigation)
    document.addEventListener('livewire:navigated', function () {
        // Small delay to ensure DOM is ready
        setTimeout(loadBestSellingProducts, 100);
    });

    // Also listen for Livewire initialization
    document.addEventListener('livewire:init', function () {
        setTimeout(loadBestSellingProducts, 100);
    });
</script>


<script>
    let homeSwiper = null;

    function initializeHomeSwiper() {
        const swiperElement = document.querySelector(".homeSwiper");

        // Return early if element not found
        if (!swiperElement) {
            return;
        }

        // Destroy existing swiper instance if it exists
        if (homeSwiper) {
            homeSwiper.destroy(true, true);
            homeSwiper = null;
        }

        // Initialize new swiper instance
        homeSwiper = new Swiper(".homeSwiper", {
            loop: true,
            centeredSlides: true,
            spaceBetween: 20,
            autoplay: {
                delay: 3000,
                disableOnInteraction: false,
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
        });
    }

    // Initialize on page load
    function initSwiperOnReady() {
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', initializeHomeSwiper);
        } else {
            // DOM already loaded
            initializeHomeSwiper();
        }
    }

    initSwiperOnReady();

    // Re-initialize when Livewire navigates (for SPA navigation)
    document.addEventListener('livewire:navigated', function () {
        // Small delay to ensure DOM is ready
        setTimeout(initializeHomeSwiper, 100);
    });

    // Also listen for Livewire initialization
    document.addEventListener('livewire:init', function () {
        setTimeout(initializeHomeSwiper, 100);
    });
</script>