<div id="page-content">
    @php
        use App\Models\Product;
        use App\Models\ComboProduct;
        use App\Services\TranslationService;
        use App\Services\StoreService;
        use App\Services\MediaService;
        use App\Services\CurrencyService;
    @endphp
    <!--Page Header-->
    <x-utility.breadcrumbs.breadcrumbTwo :$bread_crumb />
    <!--End Page Header-->
    {{-- @dd($cart_data) --}}
    <div class="container-fluid">
        @if (count($cart_data) >= 1 || count($save_for_later) >= 1)
            @if (count($cart_data) >= 1)
                <div class="row">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-8 main-col cart-box">

                        <!--Cart Form-->
                        <table class="table align-middle">
                            <thead class="cart-row cart-header small-hide">
                                <tr>
                                    <th class="action">&nbsp;</th>
                                    <th colspan="2" class="text-start">
                                        {{ labels('front_messages.product', 'Product') }}</th>
                                    <th class="text-center"></th>
                                    <th class="text-center">{{ labels('front_messages.price', 'Price') }}</th>
                                    <th class="text-center">{{ labels('front_messages.quantity', 'Quantity') }}</th>
                                    <th class="text-center">{{ labels('front_messages.total', 'Total') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $is_save_later_hide = 0;
                                    $is_remove_from_cart = 0;
                                    $for_checkout = 0;
                                @endphp
                                @foreach ($cart_data['cart_items'] as $cartItem)
                                    <x-utility.cart.CardOne :$cartItem :$is_save_later_hide :$is_remove_from_cart
                                        :$for_checkout />
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!--Cart Sidebar-->
                    <div class="col-12 col-sm-12 col-md-12 col-lg-4 cart-footer">
                        <div class="cart-info sidebar-sticky">
                            <div class="cart-order-detail cart-col">
                                <div class="row g-0 pt-2 border-bottom">
                                    <span
                                        class="col-6 col-sm-6 cart-subtotal-title fs-6"><strong>{{ labels('front_messages.total', 'Total') }}</strong></span>
                                    <span
                                        class="col-6 col-sm-6 cart-subtotal-title fs-5 cart-subtotal text-end text-primary"><b
                                            class="money">
                                            {{-- {{ app(CurrencyService::class)->currentCurrencyPrice($cart_data['sub_total'], true) }} --}}
                                            {{ app(CurrencyService::class)->formateCurrency(number_format($cart_data['sub_total'], 2)) }}</b></span>
                                </div>

                                <p class="cart-shipping">Transport charges will be actual calculated at checkout</p>
                                <a href="{{ customUrl('cart/checkout') }}" wire:navigate id="cartCheckout"
                                    class="btn btn-lg my-4 checkout w-100">{{ labels('front_messages.proceed_to_checkout', 'Proceed To Checkout') }}</a>
                            </div>
                        </div>
                    </div>
                    <!--End Cart Sidebar-->
                </div>
            @endif

            @if (count($save_for_later) >= 1)
                {{-- @dd($language_code); --}}
                <section class="section product-slider pb-0">
                    <x-utility.section_header.sectionHeaderTwo :heading="$save_for_later['heading']" />
                    <!--Product Grid-->
                    <div class="grid-products grid-view-items mt-4">
                        <div class="row col-row row-cols-xl-5 row-cols-lg-4 row-cols-md-3 row-cols-2">
                            @foreach ($save_for_later['cart_items'] as $item)
                                @php
                                    // dD($save_for_later['cart_items']);
                                    $product_img = app(MediaService::class)->dynamic_image($item->product->image, 400);
                                    $product_name = '';

                                    if ($item['cart_product_type'] == 'combo') {
                                        $product_name = app(TranslationService::class)->getDynamicTranslation(
                                            ComboProduct::class,
                                            'title',
                                            $item->product->id,
                                            $language_code,
                                        );
                                    } else {
                                        $product_name = app(TranslationService::class)->getDynamicTranslation(
                                            Product::class,
                                            'name',
                                            $item->product->id,
                                            $language_code,
                                        );
                                    }

                                @endphp
                                <div class="item col-item">
                                    <div class="product-box position-relative">
                                        <button wire:ignore type="button" 
                                            wire:click="remove_from_save_later({{ $item->product_variant_id }})"
                                            class="btn remove-icon close-btn" data-bs-toggle="tooltip"
                                            data-bs-placement="top" title="Remove"><i
                                                class="icon anm anm-times-r"></i></button>
                                        <div class="product-image">
                                            <a href="{{ customUrl('products/' . $item->product->slug) }}"
                                                class="product-img rounded-0 save_later_product_img">
                                                <img class="primary rounded-0 blur-up lazyload"
                                                    data-src="{{ $product_img }}" src="{{ $product_img }}"
                                                    alt="{{ $product_name }}" title="{{ $product_name }}" />
                                                <img class="hover rounded-0 blur-up lazyload"
                                                    data-src="{{ $product_img }}" src="{{ $product_img }}"
                                                    alt="{{ $product_name }}" title="{{ $product_name }}" />
                                            </a>
                                        </div>
                                        <div class="product-details text-center">
                                            <div class="product-name">
                                                <a
                                                    href="{{ customUrl('products/' . $item->product->slug) }}">{{ $product_name }}</a>
                                            </div>
                                            <div class="product-price">
                                                @if ($item->productVariant->special_price == 0 || $item->productVariant->special_price == null)
                                                    <span
                                                        class="price">{{ app(CurrencyService::class)->currentCurrencyPrice($item->productVariant->price, true) }}</span>
                                                @else
                                                    <span
                                                        class="price old-price">{{ app(CurrencyService::class)->currentCurrencyPrice($item->productVariant->price, true) }}</span>
                                                    <span
                                                        class="price">{{ app(CurrencyService::class)->currentCurrencyPrice($item->productVariant->special_price, true) }}</span>
                                                @endif
                                            </div>


                                            <div class="button-action mt-3">
                                                <div class="addtocart-btn">
                                                    <button wire:click="move_to_cart({{ $item->product_variant_id }})"
                                                        class="btn btn-md">
                                                        <span
                                                            class="text">{{ labels('front_messages.move_to_cart', 'Move To Cart') }}</span>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                </section>
            @endif
            @php
                $store_settings = app(StoreService::class)->getStoreSettings();
            @endphp

            {{-- <x-dynamic-component :component="$component" :details="$details" /> --}}
            @if (!empty($related_product['product']))
                <!--Related Products-->
                <section class="section product-slider pb-0">
                    <div class="">
                        <x-utility.section_header.sectionHeaderTwo :heading="$related_product_heading" />
                        <!--Product Grid-->
                        <div wire:ignore
                            class="swiper style1-mySwiper gp15 arwOut5 hov-arrow grid-products {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }}">
                            <div class="swiper-wrapper">
                                @foreach ($related_product['product'] as $details)
                                    <div class="swiper-slide ">
                                        @php
                                            $component = getProductDisplayComponent($store_settings);
                                            $details = (object) $details;
                                        @endphp

                                        <x-dynamic-component :component="$component" :details="$details" />
                                    </div>
                                @endforeach
                            </div>
                            <div class="swiper-button-next"></div>
                            <div class="swiper-button-prev"></div>
                        </div>
                        <!--End Product Grid-->
                    </div>
                </section>
                <!--End Related Products-->
            @endif
        @else
            @php
                $title =
                    '<strong>' .
                    labels('front_messages.sorry', 'SORRY ') .
                    '</strong>' .
                    labels('front_messages.cart_is_currently_empty', 'Cart is currently empty');
            @endphp
            <x-utility.others.not-found :$title />
        @endif
    </div>
    <!--End Main Content-->

</div>
@push('scripts')
    <script>
        document.addEventListener('livewire:navigated', () => {
             Livewire.on('remove_from_save_later', (data) => {
                var csrf = $('meta[name="csrf-token"]').attr("content");
                $.ajax({
                    url: "/cart/remove-from-save-later",
                    data: {
                        _token: csrf,
                        user_id: data.data.user_id,
                        product_variant_id: data.data.variant_id,
                        store_id: data.data.store_id,
                        product_type: data.data.product_type,
                    },
                    type: "POST",
                    dataType: "json",
                    success: function (result) {
                        if (result.error == false) {
                            Livewire.dispatch("refreshComponent");
                            iziToast.success({
                                message: result.message,
                                position: "topRight",
                            });
                        } else {
                            iziToast.error({
                                message: result.message,
                                position: "topRight",
                            });
                        }
                    },
                });
            });
        });
    </script>
@endpush
