@props(['category'])

@php
    use App\Services\StoreService;
    $store_settings = app(StoreService::class)->getStoreSettings();
@endphp

<div class="category-card text-center">
    <a
        href="{{ customUrl('categories/' . $category->slug . '/products') }}"
        class="category-link block no-underline"
        data-link="{{ customUrl('categories/' . $category->slug . '/products') }}"
        style="display: inline-block; text-decoration: none;">

        <div class="category-image {{ $store_settings['category_card_style'] == 'category_card_style_1' ? 'img-box-rectangle-h150' : 'img-box-h140' }} {{ $store_settings['category_card_style'] == 'category_card_style_3' ? 'rounded-circle' : '' }}">
            <img class="w-full h-full object-cover rounded-xl"
                src="{{ $category->image }}"
                alt="{{ $category->name }}">
        </div>

        <div class="mt-2">
            <h4 class="category-title text-base font-semibold capitalize mb-0">{{ $category->name }}</h4>
        </div>
    </a>
</div>
