@props(['details'])
@php
    use App\Services\TranslationService;
    use App\Services\MediaService;
    use App\Services\CurrencyService;
    use App\Models\Brand;
    use App\Models\Category;
    $language_code = app(TranslationService::class)->getLanguageCode();
@endphp
<style>
    .product-line-wrapper {
        display: flex;
        justify-content: space-between;
        gap: 10px;
        /* spacing between qty & rating */
    }

    .all-product-img {
        height: 250px !important;
        width: 100%;
        display: block;
    }

    .all-product-img img {
        width: 100%;
        height: 100% !important;
        object-fit: cover;
    }

    /* iPad and iPad Pro specific adjustment */
    @media (min-width: 768px) and (max-width: 991px) {
        .all-product-img {
            height: 180px !important;
        }

        .product-details {
            padding: 5px 0;
        }

        .product-name a {
            font-size: 14px;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        .product-vendor {
            font-size: 12px;
            margin-bottom: 2px;
        }

        .product-price .price {
            font-size: 14px;
        }

        .button-set.style1 {
            opacity: 1 !important;
            visibility: visible !important;
        }
    }

    /* iPad Pro (1024x1366) specific adjustment */
    @media (min-width: 992px) and (max-width: 1199px) {
        .all-product-img {
            height: 260px !important;
        }

        .button-set.style1 {
            opacity: 1 !important;
            visibility: visible !important;
            right: 10px !important;
            top: 10px !important;
        }

        .product-name a {
            font-size: 16px;
        }
    }
</style>

{{--@dd($details);--}}
<div class="item col-item">
    @if ($details->type != 'combo-product')
        <div class="product-box">
            <div class="product-image m-0">
                <a wire:navigate href="{{ customUrl('products/' . $details->slug) }}"
                    class="all-product-img product-img rounded-3 slider-link"
                    data-link="{{ customUrl('products/' . $details->slug) }}">


                    <img class="blur-up lazyload" src="{{ app(MediaService::class)->dynamic_image($details->image, 400) }}"
                        alt="Product" title="{{ $details->name }}" width="625" height="808" />
                </a>
                <div class="product-labels radius">
                    @if ($details->new_arrival)
                        <span class="lbl pr-label3">{{ labels('front_messages.new_arrivals', 'New Arrival') }}</span>
                    @endif

                    @if ($details->best_seller)
                        <span class="lbl pr-label4">{{ labels('front_messages.best_seller', 'Best Seller') }}</span>
                    @endif
                </div>

                <div class="button-set style1">
                    <a href="#quickview-modal" class="btn-icon quickview quick-view-modal" data-bs-toggle="modal"
                        data-bs-target="#quickview_modal" data-product-id="{{ $details->id }}">
                        <span class="icon-wrap d-flex-justify-center h-100 w-100" data-bs-toggle="tooltip"
                            data-bs-placement="left" title="Quick View"><i class="hdr-icon icon anm anm-search-l"></i><span
                                class="text">{{ labels('front_messages.quick_view', 'Quick View') }}</span>
                    </a>
                    <a class="btn-icon wishlist card_fav_btn {{ $details->is_favorite == 1 ? 'remove-favorite' : 'add-favorite' }}"
                        data-bs-toggle="tooltip" data-bs-placement="left"
                        title="{{ $details->is_favorite == 1 ? 'Remove From Wishlist' : 'Add To Wishlist' }}"
                        data-product-id="{{ $details->id }}" data-product-type="regular">
                        <i
                            class="hdr-icon anm {{ $details->is_favorite == 1 ? 'anm-heart text-danger' : 'anm-heart-l' }}"></i>
                        <span
                            class="text">{{ $details->is_favorite == 1 ? 'Remove From Wishlist' : 'Add To Wishlist' }}</span>
                    </a>

                    <a class="btn-icon compare add-compare" data-product-id="{{ $details->id }}"
                        data-product-variant-id="{{ $details->variants[0]['id'] }}" data-name="{{ $details->name }}"
                        data-slug="{{ $details->slug }}"
                        data-brand-name="{{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $details->brand, $language_code) }}"
                        data-image="{{ app(MediaService::class)->dynamic_image($details->image, 220) }}"
                        data-product-type="regular" data-max="{{ $details->total_allowed_quantity }}"
                        data-step="{{ $details->quantity_step_size }}" data-min="{{ $details->minimum_order_quantity }}"
                        data-stock-type="{{ $details->stock_type }}" data-store-id="{{ $details->store_id }}"
                        data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['special_price']) }}"
                        data-bs-toggle="tooltip" data-bs-placement="left" title="Add to Compare">

                        <i class="icon anm anm-random-r"></i>
                        <span class="text">{{ labels('front_messages.add_to_compare', 'Add to Compare') }}</span>

                    </a>

                </div>
            </div>
            <div class="product-details">
                <a wire:navigate href="{{ customUrl('products/?brand=' . $details->brand_slug) }}"
                    class="slider-link product-vendor text-uppercase"
                    data-link="{{ customUrl('products/?brand=' . $details->brand_slug) }}">{!! app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $details->brand, $language_code) !!}</a>
                <div class="product-name text-capitalize">
                    <a wire:navigate href="{{ customUrl('products/' . $details->slug) }}" class="slider-link text-ellipsis"
                        data-link="{{ customUrl('products/' . $details->slug) }}"
                        title="{!! $details->name !!}">{!! $details->name !!} </a>
                </div>
                <div class="product-price">
                    @php
                        if ($details->type == 'variable_products') {
                            $price = app(CurrencyService::class)->currentCurrencyPrice($details->min_max_price['max_price'], true);
                            $special_price =
                                $details->min_max_price['special_min_price'] &&
                                $details->min_max_price['special_min_price'] > 0
                                ? app(CurrencyService::class)->currentCurrencyPrice($details->min_max_price['special_min_price'], true)
                                : $price;
                        } else {
                            $price = app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['price'], true);
                            $special_price =
                                $details->variants[0]['special_price'] && $details->variants[0]['special_price'] > 0
                                ? app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['special_price'], true)
                                : $price;
                        }
                    @endphp
                    <span class="price old-price">{{ $special_price !== $price ? $price : '' }}</span>
                    <span class="price fw-500"><span wire:model="price">{{ $special_price }}</span></span>
                </div>

                <div>
                    {{-- <p class="sort-desc hidden">{!! $details->short_description !!}</p> --}}
                    <a wire:navigate href="{{ customUrl('categories/' . $details->category_slug . '/products') }}"
                        data-link="{{ customUrl('categories/' . $details->category_slug . '/products') }}"
                        class="slider-link  text-secondary"
                        title="{!! app(TranslationService::class)->getDynamicTranslation(Category::class, 'name', $details->category_id, $language_code) !!}"><ion-icon
                            name="layers-outline"
                            class="custom-icon fs-6 me-1"></ion-icon>{!! app(TranslationService::class)->getDynamicTranslation(Category::class, 'name', $details->category_id, $language_code) !!}
                    </a>
                </div>
                <div class="product-line-wrapper">
                    <div class="product-review">
                        <input id="input-3-ltr-star-md" name="input-3-ltr-star-md"
                            class="kv-ltr-theme-svg-star rating-loading d-none" value="{{ $details->rating }}" dir="ltr"
                            data-size="xs" data-show-clear="false" data-show-caption="false" readonly>
                    </div>
                    {{--
                    <div class="qtyDetail text-end cart-qtyDetail d-none"
                        id="qty-section-{{ $details->variants[0]['id'] }}">
                        <div class="qtyField">
                            <button wire:ignore class="qtyBtn minus" href="#;">
                                <ion-icon name="remove-outline"></ion-icon>
                            </button>
                            <input type="number" name="quantity" class="product-form-input qty"
                                value="{{ $details->minimum_order_quantity }}"
                                max="{{ $details->total_allowed_quantity == 0 ? 'Infinity' : $details->total_allowed_quantity }}"
                                step="{{ $details->quantity_step_size }}" min="{{ $details->minimum_order_quantity }}"
                                data-variant-id="{{ $details->variants[0]['id'] }}"
                                data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['special_price']) }}"
                                data-product-type="regular" />
                            <button wire:ignore class="qtyBtn plus" href="#;">
                                <ion-icon name="add-outline"></ion-icon>
                            </button>
                        </div>
                    </div>
                    --}}

                </div>
                @if ($details->type == 'variable_product')
                    <div class="button-action mt-2">
                        <div class="addtocart-btn">
                            <a href="#quickview-modal"
                                class="button-style d-flex align-items-center btn btn-md quickview quick-view-modal p-2"
                                data-bs-toggle="modal" data-bs-target="#quickview_modal" data-product-id="{{ $details->id }}"
                                data-product-variant-id=''>
                                <i class="anm anm-bag-l hdr-icon me-2"></i>
                                <span class="text button-text">{{ labels('front_messages.add_to_cart', 'Add to Cart') }}</span>

                            </a>
                        </div>
                    </div>
                @else
                    {{--
                    <div class="button-action mt-2">
                        <div class="addtocart-btn add_cart" data-product-variant-id="{{ $details->variants[0]['id'] }}"
                            data-name="{{ $details->name }}" data-slug="{{ $details->slug }}"
                            data-brand-name="{{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $details->brand, $language_code) }}"
                            data-image="{{ app(MediaService::class)->dynamic_image($details->image, 220) }}"
                            data-product-type="regular" data-max="{{ $details->total_allowed_quantity }}"
                            data-step="{{ $details->quantity_step_size }}" data-min="{{ $details->minimum_order_quantity }}"
                            data-stock-type="{{ $details->stock_type }}" data-store-id="{{ $details->store_id }}"
                            data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['special_price']) }}">
                            <a class="btn btn-md p-2 button-style d-flex align-items-center">
                                <i class="anm anm-bag-l hdr-icon me-2"></i>
                                <span class="text button-text">Add to Cart</span>
                            </a>
                        </div>
                    </div>
                    --}}
                    @php
                        $inCart = !empty($details->is_in_cart);
                        $cartQty = $details->cart_qty ?? $details->qty ?? $details->minimum_order_quantity;
                    @endphp

                    <div class="button-action mt-2">
                        <div class="addtocart-btn add_cart {{ $inCart ? 'd-none' : '' }}"
                            data-product-variant-id="{{ $details->variants[0]['id'] }}" data-name="{{ $details->name }}"
                            data-slug="{{ $details->slug }}"
                            data-brand-name="{{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $details->brand, $language_code) }}"
                            data-image="{{ app(MediaService::class)->dynamic_image($details->image, 220) }}"
                            data-product-type="regular" data-max="{{ $details->total_allowed_quantity }}"
                            data-step="{{ $details->quantity_step_size }}" data-min="{{ $details->minimum_order_quantity }}"
                            data-stock-type="{{ $details->stock_type }}" data-store-id="{{ $details->store_id }}"
                            data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['special_price']) }}">

                            <a class="btn btn-md p-2 button-style d-flex align-items-center">
                                <i class="anm anm-bag-l hdr-icon me-2"></i>
                                <span class="button-text">Add to Cart</span>
                            </a>
                        </div>

                        <!-- Qty block (hidden by default) -->
                        <div class="qtyDetail text-end cart-qtyDetail  {{ $inCart ? '' : 'd-none' }}">
                            <div class="qtyField">

                                <button class="qtyBtn minus">
                                    <ion-icon name="remove-outline"></ion-icon>
                                </button>

                                <input type="number" name="quantity" style="width: 100% !important;"
                                    class="product-form-input qty" value="{{ $cartQty }}"
                                    max="{{ $details->total_allowed_quantity == 0 ? 'Infinity' : $details->total_allowed_quantity }}"
                                    step="{{ $details->quantity_step_size }}" min="{{ $details->minimum_order_quantity }}"
                                    data-variant-id="{{ $details->variants[0]['id'] }}"
                                    data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->variants[0]['special_price']) }}"
                                    data-product-type="regular" />

                                <button wire:ignore class="qtyBtn plus">
                                    <ion-icon name="add-outline"></ion-icon>
                                </button>
                            </div>
                        </div>
                    </div>


                @endif
            </div>
        </div>
    @else
        <div class="product-box">
            <div class="product-image m-0">
                <a wire:navigate href="{{ customUrl('combo-products/' . $details->slug) }}"
                    class="all-product-img product-img rounded-3 slider-link"
                    data-link="{{ customUrl('combo-products/' . $details->slug) }}">
                    <img class="blur-up lazyload" src="{{ app(MediaService::class)->dynamic_image($details->image, 400) }}"
                        alt="{{ $details->name }}" title="{{ $details->name }}" width="625" height="808" />
                </a>
                <div class="product-labels radius">
                    @if ($details->new_arrival)
                        <span class="lbl pr-label3">{{ labels('front_messages.new_arrivals', 'New Arrival') }}</span>
                    @endif

                    @if ($details->best_seller)
                        <span class="lbl pr-label4">{{ labels('front_messages.best_seller', 'Best Seller') }}</span>
                    @endif
                </div>
                <div class="button-set style1">
                    <a href="#quickview-modal" class="btn-icon quickview quick-view-modal" data-bs-toggle="modal"
                        data-bs-target="#quickview_modal" data-product-id="{{ $details->id }}"
                        data-product-type="{{ $details->type }}">
                        <span class="icon-wrap d-flex-justify-center h-100 w-100" data-bs-toggle="tooltip"
                            data-bs-placement="left" title="Quick View"><i class="hdr-icon icon anm anm-search-l"></i><span
                                class="text">{{ labels('front_messages.quick_view', 'Quick View') }}</span>
                    </a>
                    <a class="btn-icon wishlist card_fav_btn {{ $details->is_favorite == 1 ? 'remove-favorite' : 'add-favorite' }}"
                        data-bs-toggle="tooltip" data-bs-placement="left"
                        title="{{ $details->is_favorite == 1 ? 'Remove From Wishlist' : 'Add To Wishlist' }}"
                        data-product-id="{{ $details->id }}" data-product-type="combo">
                        <i
                            class="hdr-icon anm {{ $details->is_favorite == 1 ? 'anm-heart text-danger' : 'anm-heart-l' }}"></i>
                        <span
                            class="text">{{ $details->is_favorite == 1 ? 'Remove From Wishlist' : 'Add To Wishlist' }}</span>
                    </a>

                    <a class="btn-icon compare add-compare" data-product-id="{{ $details->id }}"
                        data-product-variant-id="{{ $details->id }}"
                        data-name="{{ $details->name ?? ($details->title ?? '') }}" data-slug="{{ $details->slug }}"
                        data-brand-name="{{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $details->brand, $language_code) }}"
                        data-image="{{ app(MediaService::class)->dynamic_image($details->image, 220) }}"
                        data-product-type="combo" data-max="{{ $details->total_allowed_quantity }}"
                        data-step="{{ $details->quantity_step_size }}" data-min="{{ $details->minimum_order_quantity }}"
                        data-stock-type="{{ $details->stock_type }}" data-store-id="{{ $details->store_id }}"
                        data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->special_price > 0 ? $details->special_price : $details->price, false) }}"
                        data-bs-toggle="tooltip" data-bs-placement="left" title="Add to Compare"><i
                            class="icon anm anm-random-r"></i><span
                            class="text">{{ labels('front_messages.add_to_compare', 'Add to Compare') }}</span></a>
                </div>
            </div>
            <div class="product-details">
                <div class="product-name text-capitalize">
                    <a wire:navigate href="{{ customUrl('combo-products/' . $details->slug) }}"
                        class="slider-link text-ellipsis" data-link="{{ customUrl('combo-products/' . $details->slug) }}"
                        title="{!! $details->name !!}">{!! $details->name !!}</a>
                </div>
                <div class="product-price">
                    @php
                        $price = app(CurrencyService::class)->currentCurrencyPrice($details->price, true);
                        $special_price =
                            $details->special_price && $details->special_price > 0
                            ? app(CurrencyService::class)->currentCurrencyPrice($details->special_price, true)
                            : $price;
                    @endphp
                    <span
                        class="price old-price">{{ $details->special_price && $details->special_price > 0 ? $price : '' }}</span>
                    <span class="price fw-500">{{ $special_price }}</span>
                </div>
                <div class="product-review">
                    <input id="input-3-ltr-star-md" name="input-3-ltr-star-md"
                        class="kv-ltr-theme-svg-star rating-loading d-none" value="{{ $details->rating }}" dir="ltr"
                        data-size="xs" data-show-clear="false" data-show-caption="false" readonly>
                </div>

                @if ($details->type == 'variable_product')
                    <div class="button-action mt-2">
                        <div class="addtocart-btn">
                            <a href="#quickview-modal"
                                class="button-style d-flex align-items-center btn btn-md quickview quick-view-modal p-2"
                                data-bs-toggle="modal" data-bs-target="#quickview_modal" data-product-id="{{ $details->id }}"
                                data-product-variant-id=''>
                                <i class="anm anm-bag-l hdr-icon me-2"></i>
                                <span class="text button-text">{{ labels('front_messages.add_to_cart', 'Add to Cart') }}</span>

                            </a>
                        </div>
                    </div>
                @else
                    {{--
                    <div class="button-action mt-2">
                        <div class="addtocart-btn add_cart" id="add_cart" data-product-variant-id="{{ $details->id }}"
                            data-name='{{ $details->name }}' data-slug='{{ $details->slug }}'
                            data-image='{{ app(MediaService::class)->dynamic_image($details->image, 220) }}'
                            data-product-type='combo' data-max='{{ $details->total_allowed_quantity }}'
                            data-step='{{ $details->quantity_step_size }}' data-min='{{ $details->minimum_order_quantity }}'
                            data-stock-type='{{ $details->stock_type }}' data-store-id='{{ $details->store_id }}'
                            data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->special_price) }}">
                            <a class="btn btn-md p-2 button-style d-flex align-items-center"
                                data-product-id="{{ $details->id }}">
                                <i class="anm anm-bag-l hdr-icon me-2"></i>
                                <span class="text button-text">{{ labels('front_messages.add_to_cart', 'Add to Cart') }}</span>

                            </a>
                        </div>
                    </div>

                    --}}

                    @php
                        $inCart = !empty($details->is_in_cart);
                        $cartQty = $details->cart_qty ?? $details->qty ?? $details->minimum_order_quantity;
                    @endphp

                    <div class="button-action mt-2">
                        {{-- Add to Cart button (hide when already in cart) --}}
                        <div class="addtocart-btn add_cart {{ $inCart ? 'd-none' : '' }}"
                            data-product-variant-id="{{ $details->id }}" data-name="{{ $details->name }}"
                            data-slug="{{ $details->slug }}"
                            data-brand-name="{{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $details->brand, $language_code) }}"
                            data-image="{{ app(MediaService::class)->dynamic_image($details->image, 220) }}"
                            data-product-type="combo" data-max="{{ $details->total_allowed_quantity }}"
                            data-step="{{ $details->quantity_step_size }}" data-min="{{ $details->minimum_order_quantity }}"
                            data-stock-type="{{ $details->stock_type }}" data-store-id="{{ $details->store_id }}"
                            data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->special_price) }}">

                            <a class="btn btn-md p-2 button-style d-flex align-items-center">
                                <i class="anm anm-bag-l hdr-icon me-2"></i>
                                <span class="button-text">Add to Cart</span>
                            </a>
                        </div>

                        <!-- Qty block (visible when in cart) -->
                        <div class="qtyDetail text-end cart-qtyDetail {{ $inCart ? '' : 'd-none' }}">
                            <div class="qtyField">
                                <button class="qtyBtn minus">
                                    <ion-icon name="remove-outline"></ion-icon>
                                </button>

                                <input type="number" name="quantity" style="width: 100% !important;"
                                    class="product-form-input qty" value="{{ $cartQty }}"
                                    max="{{ $details->total_allowed_quantity == 0 ? 'Infinity' : $details->total_allowed_quantity }}"
                                    step="{{ $details->quantity_step_size }}" min="{{ $details->minimum_order_quantity }}"
                                    data-variant-id="{{  $details->id  }}"
                                    data-variant-price="{{ app(CurrencyService::class)->currentCurrencyPrice($details->special_price) }}"
                                    data-product-type="combo" />

                                <button wire:ignore class="qtyBtn plus">
                                    <ion-icon name="add-outline"></ion-icon>
                                </button>
                            </div>
                        </div>
                    </div>



                @endif
            </div>
        </div>
    @endif
</div>