@php
use App\Services\TranslationService;
use App\Services\CartService;
use App\Services\StoreService;
use App\Services\MediaService;
use App\Models\Store;
$store_id = session('store_id');
$store_details = app(StoreService::class)->getCurrentStoreData($store_id);
$store_details = json_decode($store_details) ?? '';
$language_code = app(TranslationService::class)->getLanguageCode();
$menuCategories = collect($categories['categories'] ?? [])->map(fn($category) => (object) $category);
@endphp
<style>
    .mobile-nav-wrapper {
    position: fixed;
    top: 0;
    left: -100%;
    width: 280px;
    height: 100%;
    background: #fff;
    z-index: 9999;
    transition: all 0.3s ease;
    overflow-y: auto;
}

.mobile-nav-wrapper.active {
    left: 0;
}

.mobile-search-overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #fff;
    z-index: 10000;
    display: none;
    flex-direction: column;
}

.mobile-search-header {
    display: flex;
    align-items: center;
    padding: 15px;
    border-bottom: 1px solid #eee;
}

.mobile-search-header .back-btn {
    background: none;
    border: none;
    font-size: 24px;
    margin-right: 15px;
    display: flex;
    align-items: center;
    color: #666;
}

.mobile-search-header .title {
    font-size: 18px;
    font-weight: 500;
    color: #333;
}

.mobile-search-body {
    padding: 15px;
    flex: 1;
    overflow-y: auto;
}

    .top-header-bg {
       background-color: var(--primary-color);
        /* ✅ Deep green shade */
        color: #fff;
    }
    .top-header{
        padding-bottom: 3px !important;
        padding-top: 3px !important;
    }

    /* .products-dropdown .megamenu {
        min-width: 520px;
        padding: 24px;
    }
    .products-dropdown .dropdown-title {
        font-weight: 600;
        display: block;
        padding: 4px 0;
        color: #041632;
        text-decoration: none;
    }
    .products-dropdown .dropdown-title:hover {
        color: #5dc943;
    } */
    /* Remove large gaps between li elements */
    .products-dropdown {
        position: relative;
    }

    .products-dropdown .megamenu {
        position: absolute;
        top: 100%;
        left: 0;
        min-width: 260px;
        max-width: 600px;
        padding: 12px;
        z-index: 999;
    }

    .products-dropdown .megamenu .row {
        margin: 0 !important;
        width: 100%;
    }

    html,
    body {
        overflow-x: hidden;
    }

    /* Vertical Megamenu Styles */
    .vertical-megamenu-wrapper {
        position: relative;
    }

    .vertical-megamenu {
        position: absolute;
        top: 100%;
        left: 0;
        background: #fff;
        box-shadow: 0 4px 10px rgba(0,0,0,0.1);
        min-width: 250px;
        display: none;
        z-index: 1000;
        border-radius: 4px;
        padding: 10px 0;
    }

    .lvl1.parent:hover > .vertical-megamenu {
        display: block;
    }

    .vertical-menu-item {
        position: relative;
        list-style: none;
    }

    .vertical-menu-link {
        display: block;
        padding: 10px 20px;
        color: #333;
        text-decoration: none;
        transition: all 0.3s;
        font-weight: 500;
    }

    .vertical-menu-item:hover > .vertical-menu-link {
        background-color: #f8f9fa;
        color: #5dc943;
    }

    .submenu-panel {
        position: absolute;
        top: 0;
        left: 100%;
        background: #fff;
        box-shadow: 4px 4px 10px rgba(0,0,0,0.1);
        min-width: 250px;
        height: 100%;
        min-height: 200px;
        display: none;
        border-right: 1px solid #eee;
        padding: 10px 0;
        border-radius: 0 4px 4px 0;
    }

    .vertical-menu-item:hover > .submenu-panel {
        display: block;
    }

    .submenu-panel .vertical-menu-link:hover {
        color: #5dc943;
    }

    /* Tablet/iPad Pro Fixes (1024px) */
    @media only screen and (min-width: 992px) and (max-width: 1200px) {
        .site-nav > li > a {
            padding: 0 8px !important;
            font-size: 13px !important;
        }
        .header-cart, .wishlist-link, .account-parent {
            margin-left: 8px !important;
        }
        .icons-col {
            padding-left: 5px !important;
            padding-right: 5px !important;
        }
    }
</style>
<div>

    <input type="hidden" id="store-primary-color" name="store-primary-color"
        value="{{ $store_details[0]->primary_color ?? '#041632' }}">
    <input type="hidden" id="store-secondary-color" name="store-secondary-color"
        value="{{ $store_details[0]->secondary_color ?? '#f4a51c' }}">
    <input type="hidden" id="store-link-active-color" name="store-link-active-color"
        value="{{ $store_details[0]->active_color ?? '#041632' }}">
    <input type="hidden" id="store-link-hover-color" name="store-link-hover-color"
        value="{{ $store_details[0]->hover_color ?? '#f4a51c' }}">
    <div class="top-header top-header-bg">
        <div class="container-fluid ">
            <div class="row align-items-center justify-content-between">
                <div class="col-6 col-sm-6 col-md-3 col-lg-4 text-left d-flex">
                    <ion-icon wire:ignore class="fs-5 me-2" name="call-outline"></ion-icon><a style="color: #fff;"
                        href="tel:{{ $settings->support_number }}">{{ $settings->support_number }} </a>
                </div>
                {{--
                <div class="col-12 col-sm-12 col-md-6 col-lg-4 text-center d-flex justify-content-center d-none d-md-block">
                    <span>{{ $settings->app_short_description }}</span>
                    <span style="color:black; font-weight: 600; cursor: pointer;" wire:navigate href="{{ customUrl('products') }}">SHOP NOW</span>
                </div>
                --}}
                <div class="col-6 col-sm-6 col-md-3 col-lg-4 text-right d-flex align-items-center justify-content-end">
                    <!-- <li class="lvl1 parent megamenu"> -->
                    <a wire:navigate
                          href="{{ customUrl('calculator') }}">
                        <span class="hover:text-white cursor-pointer text-white">{{ labels('front_messages.calculator', 'Calculator') }}</span>
                    </a>
                    <!-- </li>     -->
                    <div class="select-wrap language-picker float-start">

                        @if (count($languages) > 1)
                        <ul class="default-option">
                            <li>
                                <div class="option english">
                                    <span>{{ session('locale') ?? ($languages[0]->code ?? 'en') }}</span>
                                </div>
                            </li>
                        </ul>
                        @else
                        <div class="option english">
                            <span>{{ session('locale') ?? ($languages[0]->code ?? 'en') }}</span>
                        </div>
                        @endif

                        @if (count($languages) > 1)
                        <ul class="select-ul">
                            @foreach ($languages as $language)
                            <li class="option english changeLang" data-lang-code="{{ $language->code }}">
                                <div>
                                    <span>{{ $language->code }}</span>
                                </div>
                            </li>
                            @endforeach
                            <li>
                        </ul>
                        @endif

                    </div>
                    {{-- <div class="select-wrap currency-picker float-start">
                        @if (count($currencies) > 1)
                            <ul class="default-option">
                                <li>
                                    <div class="option USD">
                                        <span>{{ session('currency') ?? ($system_settings['currency_setting']['code'] ?? 'USD') }}</span>
                    @if (count($currencies) > 1)
                    <i class="arrow-icon"></i>
                    @endif
                </div>
                </li>
                </ul>
                @else
                <div class="option USD">
                    <span>{{ session('currency') ?? ($system_settings['currency_setting']['code'] ?? 'USD') }}</span>
                    @if (count($currencies) > 1)
                    <i class="arrow-icon"></i>
                    @endif
                </div>
                @endif
                @if (count($currencies) > 1)
                <ul class="select-ul">
                    @foreach ($currencies as $currency)
                    <li class="option USD changeCurrency" data-currency-code="{{ $currency->code }}">
                        <div>
                            <span>{{ $currency->code }}</span>
                        </div>
                    </li>
                    @endforeach
                </ul>
                @endif
            </div> --}}


        </div>
    </div>
</div>
</div>
<!--End Top Header-->

<!--Header-->
<header  class="header d-flex align-items-center header-1 header-fixed">
    <div id="app_url" data-app-url="{{ route('home') }}"></div>
    <div class="container-fluid">
        <div class="row">
            {{-- @dd($store_details) --}}
            @php
            $img =
            !empty($store_details[0]->half_store_logo) &&
            file_exists(
            public_path(config('constants.STORE_IMG_PATH') . $store_details[0]->half_store_logo),
            )
            ? app(MediaService::class)->getImageUrl(
            $store_details[0]->half_store_logo,
            '',
            '',
            'image',
            'STORE_IMG_PATH',
            )
            : app(MediaService::class)->getImageUrl($settings->logo);
            $img = app(MediaService::class)->dynamic_image($img, 150);
            @endphp
            <!--Logo-->
            <div class="logo col-4 col-lg-2 align-self-center">
                <a wire:navigate href="{{ customUrl('home') }}"><img style="width: 120px; height: auto; max-height: 80px; object-fit: contain;" src="{{ $img }}"
                        alt="{{ $settings->site_title }}" title="{{ $settings->site_title }}" /></a>
            </div>

            <!--End Logo-->
            <!--Menu-->
            <div class="col-1 col-sm-2 col-md-2 col-lg-4 align-self-center d-menu-col d-none d-lg-block">
                <nav class="navigation" id="AccessibleNav">
                    <ul id="siteNav" class="site-nav medium center">
                        <li class="lvl1 parent dropdown"><a wire:navigate
                                href="{{ customUrl('home') }}">{{ labels('front_messages.home', 'Home') }} </a>
                        </li>


                        <li class="lvl1 parent products-dropdown vertical-megamenu-wrapper">
                            <a wire:navigate href="{{ customUrl('products') }}">{{ labels('front_messages.products', 'Products') }}</a>
                            @if ($menuCategories->count() >= 1)
                                <ul class="vertical-megamenu">
                                    @foreach ($menuCategories as $category)
                                        <li class="vertical-menu-item">
                                            <a wire:navigate href="{{ customUrl('categories/' . $category->slug . '/products') }}" class="vertical-menu-link d-flex justify-content-between align-items-center">
                                                {{ $category->name }}
                                                @if(!empty($category->children))
                                                    <ion-icon name="chevron-forward-outline" class="fs-6"></ion-icon>
                                                @endif
                                            </a>
                                            @if(!empty($category->children))
                                                <ul class="submenu-panel">
                                                    @foreach($category->children as $child)
                                                        @php
                                                            $child = (object)$child;
                                                        @endphp
                                                        <li class="vertical-menu-item">
                                                            <a wire:navigate href="{{ customUrl('categories/' . $child->slug . '/products') }}" class="vertical-menu-link d-flex justify-content-between align-items-center">
                                                                {{ $child->name }}
                                                                @if(!empty($child->children))
                                                                    <ion-icon name="chevron-forward-outline" class="fs-6"></ion-icon>
                                                                @endif
                                                            </a>
                                                            @if(!empty($child->children))
                                                                <ul class="submenu-panel">
                                                                    @foreach($child->children as $grandchild)
                                                                        @php
                                                                            $grandchild = (object)$grandchild;
                                                                        @endphp
                                                                        <li class="vertical-menu-item">
                                                                            <a wire:navigate href="{{ customUrl('categories/' . $grandchild->slug . '/products') }}" class="vertical-menu-link">
                                                                                {{ $grandchild->name }}
                                                                            </a>
                                                                        </li>
                                                                    @endforeach
                                                                </ul>
                                                            @endif
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            @endif
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </li>
                        <li class="lvl1 parent megamenu"><a wire:navigate
                                href="{{ customUrl('combo-products') }}">{{ labels('front_messages.combo_products', 'Combos ') }}
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>

            <!--End Menu-->

            <!-- Mobile Icons (Search + Menu) d-lg-none -->
            <div class="col-8 col-lg-8 align-self-center  d-lg-none">
                <div class="d-flex justify-content-end align-items-center gap-2">
                    <!-- Mobile Search Icon -->
                    <div class="iconset pe-0 search-icon-mobile" title="Search">
                        <ion-icon wire:ignore class="fs-5" name="search-outline"></ion-icon>
                    </div>

                    <!--Mobile Menu Toggle-->
                    <button type="button"
                        class="iconset pe-0 menu-icon js-mobile-nav-toggle mobile-nav--open"
                        title="Menu"><ion-icon wire:ignore class="fs-5" name="menu"></ion-icon></button>

                    <!--End Mobile Toggle-->
                </div>
            </div>
            <!-- End Mobile Icons -->

             <!-- Desktop Search bar -->
            <div class="col-12 col-md-3 col-lg-3 align-self-center mt-2 mt-lg-0 d-none d-lg-block">
              <livewire:header.search-product />
            </div>

            <!-- Mobile Search Overlay -->
            <div class="mobile-search-overlay">
                <div class="mobile-search-header">
                    <button type="button" class="back-btn search-close-mobile">
                        <ion-icon name="arrow-back-outline"></ion-icon>
                    </button>
                    <span class="title">Search</span>
                </div>
                <div class="mobile-search-body">
                    <livewire:header.search-product />
                </div>
            </div>
            <!-- End Search bar -->
            <!--Right Icon-->
            <div class="col-7 col-sm-9 col-md-9 col-lg-3 align-self-center icons-col text-right d-none d-lg-block">
                <!--Search-->
                {{--
                <!-- <div class="search-parent iconset">
                    <div class="site-search" title="Search">
                        <a href="#;" class="search-icon clr-none" data-bs-toggle="offcanvas"
                            data-bs-target="#search-drawer"><i class="hdr-icon icon anm anm-search-l"></i></a>
                    </div>
                </div> -->
                --}}
                <!--End Search-->

                @php
                $cart_count = '0';
                @endphp
                @auth
                @php

                $user_id = auth()->id() ?? 0;
                $store_id = session('store_id') ?? '';
                $favorites = getFavorites(user_id: $user_id, store_id: $store_id);
                $cart_count = app(CartService::class)->getCartCount($user_id, $store_id);
                @endphp
                <!--Wishlist-->
                <div class="wishlist-link iconset" title="Wishlist"><a wire:navigate
                        href="{{ customUrl('my-account.favorites') }}" class="text-black"><i
                            class="anm anm-heart anm-heart-l hdr-icon icon"></i><span
                            class="wishlist-count">{{ $favorites['favorites_count'] }}</span></a>
                </div>
                <!--End Wishlist-->
                @endauth
                <!--Minicart-->
                <div class="header-cart iconset" title="Cart">
                    <a href="#;" class="header-cart btn-minicart clr-none" data-bs-toggle="offcanvas"
                        data-bs-target="#minicart-drawer"><i class="hdr-icon icon anm anm-cart-l"></i><span
                            class="cart-count">{{ $cart_count }}</span></a>
                </div>
                <!--End Minicart-->
                  <!--Account-->
                <div class="account-parent iconset ">



                     @auth
                      <div class="account-link" title="Account"><i class="hdr-icon icon anm anm-user-al"></i></div>

                     @else
                      <div class="account-link" >
                        <Button type="button" class="btn btn-btn" data-bs-toggle="modal" >Login
                        </button>
                    </div>

                     @endauth
                    <div id="accountBox">
                        <div class="customer-links">
                            <ul class="m-0">
                                @auth

                                <li><a href="{{ customUrl('my-account') }}" wire:navigate><i
                                            class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.my_account', 'My Account') }}</a>
                                </li>
                                <li><a href="{{ customUrl('orders') }}" wire:navigate><i
                                            class="anm anm-bag-l hdr-icon icon"></i>{{ labels('front_messages.my_orders', 'My Orders') }}</a>
                                </li>
                                {{--
                                <li><a href="{{ customUrl('my-account/wallet') }}" wire:navigate><i
                                            class="anm anm-pay-security hdr-icon icon"></i>{{ labels('front_messages.wallet', 'Wallet') }}</a>
                                </li>
                                --}}
                                <li><a class="logout"><i
                                            class="anm anm-arrow-al-left hdr-icon icon"></i>{{ labels('front_messages.sign_out', 'Sign out') }}</a>
                                </li>
                                @else
                                <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#loginModal"><i
                                            class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i>{{ labels('front_messages.sign_in', 'Login as Customer') }}</a>
                                </li>
                                 <li>
                                    <a href="https://solarmart.neuromonk.co.in/seller/login">
                                       <i class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i>{{ labels('front_messages.sign_in', 'Login as Seller') }}
                                    </a>
                                </li>
                                {{--

                                <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#registerModal"><i
                                            class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.register', 'Register as Customer') }}</a>
                                </li>
                                  <li>
                                    <a href="https://solarmart.neuromonk.co.in/seller/register">
                                                       <i class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.sign_in', 'Register as Seller') }}
                                    </a>
                                </li>
                                --}}
                                @endauth
                            </ul>
                        </div>
                    </div>
                </div>
                <!--End Account-->
                <!--Mobile Toggle-->
                <!-- <button type="button"
                    class="iconset pe-0 menu-icon js-mobile-nav-toggle mobile-nav--open d-lg-none"
                    title="Menu"><ion-icon wire:ignore class="fs-5" name="menu"></ion-icon></button> -->
                <!--End Mobile Toggle-->
            </div>
            <!--End Right Icon-->
        </div>
    </div>
</header>
<!--End Header-->

<!-- Login Modal -->
<div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-0">
                @livewire('RegisterAndLogin.Login', ['isModal' => true])
            </div>
        </div>
    </div>
</div>

<!-- Register Modal -->
<div class="modal fade" id="registerModal" tabindex="-1" aria-labelledby="registerModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-0">
                @livewire('RegisterAndLogin.Register', ['isModal' => true])
            </div>
        </div>
    </div>
</div>

<!-- Forgot Password Modal -->
<div class="modal fade" id="forgotPasswordModal" tabindex="-1" aria-labelledby="forgotPasswordModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content rounded-4 border-0 shadow-lg">
            <div class="modal-header border-0 pb-0">
                <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body p-4 pt-0">
                @livewire('RegisterAndLogin.ForgetPassword', ['isModal' => true])
            </div>
        </div>
    </div>
</div>

<!--Mobile Menu-->
<div class="mobile-nav-wrapper"  >
    <div class="closemobileMenu">{{ labels('front_messages.close_menu', 'Close Menu') }}<ion-icon
            name="close-outline" class="icon"></ion-icon></div>
    <ul id="MobileNav" class="mobile-nav">
        <li class="lvl1 parent dropdown"><a
                href="{{ customUrl('home') }}">{{ labels('front_messages.home', 'Home') }}</a>
        </li>
        <li class="lvl1 parent dropdown">
            <a href="{{ customUrl('products') }}" >{{ labels('front_messages.products', 'Products') }} <span class="anm anm-angle-down-l" style="float: right;"></span></a>
            @if ($menuCategories->count() >= 1)
            <ul class="sub-menu" style="display: none;">
                <li><a wire:navigate href="{{ customUrl('products') }}">{{ labels('front_messages.all_products', 'All Products') }}</a></li>
                @foreach ($menuCategories as $category)
                <li>
                    <a wire:navigate href="{{ customUrl('categories/' . $category->slug . '/products') }}">
                        {{ $category->name }}
                        @if(!empty($category->children))
                        <span class="anm anm-angle-down-l" style="float: right;"></span>
                        @endif
                    </a>
                    @if(!empty($category->children))
                    <ul class="sub-menu" style="display: none;">
                        @foreach($category->children as $child)
                        @php $child = (object)$child; @endphp
                        <li>
                            <a wire:navigate href="{{ customUrl('categories/' . $child->slug . '/products') }}">
                                {{ $child->name }}
                                @if(!empty($child->children))
                                <span class="anm anm-angle-down-l" style="float: right;"></span>
                                @endif
                            </a>
                            @if(!empty($child->children))
                            <ul class="sub-menu" style="display: none;">
                                @foreach($child->children as $grandchild)
                                @php $grandchild = (object)$grandchild; @endphp
                                <li>
                                    <a wire:navigate href="{{ customUrl('categories/' . $grandchild->slug . '/products') }}">
                                        {{ $grandchild->name }}
                                    </a>
                                </li>
                                @endforeach
                            </ul>
                            @endif
                        </li>
                        @endforeach
                    </ul>
                    @endif
                </li>
                @endforeach
            </ul>
            @endif
        </li>
        <li class="lvl1 parent megamenu"><a wire:navigate
                 href="{{ customUrl('combo-products') }}">{{ labels('front_messages.combo_products', 'Combos ') }}
            </a>
        </li>
        {{-- <li class="lvl1 parent megamenu"><a wire:navigate
                    href="{{ customUrl('compare') }}">{{ labels('front_messages.compare', 'Compare') }}
        </a>
        </li>
        <li class="lvl1 parent megamenu"><a wire:navigate
                href="{{ customUrl('offers') }}">{{ labels('front_messages.offers', 'Offers') }} </a>
        </li>
        <li class="lvl1 parent megamenu"><a wire:navigate
                href="{{ customUrl('sellers') }}">{{ labels('front_messages.sellers', 'Sellers') }} </a>
        </li> --}}
        {{-- <li class="lvl1 parent megamenu">
                <a href="#;"class="header-cart btn-minicart clr-none" data-bs-toggle="offcanvas"
                    data-bs-target="#minicart-drawer-stores">{{ labels('front_messages.stores', 'Stores') }}</a>
        </li> --}}
        <li class="lvl1 parent dropdown"><a wire:navigate
                href="{{ customUrl('contact_us') }}">{{ labels('front_messages.contact_us', 'Contact Us') }}
            </a>
        </li>
        <li class="lvl1 parent dropdown"><a wire:navigate
                href="{{ customUrl('faqs') }}">{{ labels('front_messages.faqs', 'FAQs') }} </a>
        </li>
        <!-- <li class="lvl1 parent dropdown"><a wire:navigate
                    href="{{ customUrl('blogs') }}">{{ labels('front_messages.blogs', 'Blogs') }} </a>
            </li> -->

        <li class="mobile-menu-bottom">
            <div class="mobile-links">
                <ul class="list-inline d-inline-flex flex-column w-100">
                    @auth
                    <li><a href="{{ customUrl('my-account') }}" wire:navigate
                            class="d-flex align-items-center"><i
                                class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.my_account', 'My Account') }}</a>
                    </li>
                     <li><a href="{{ route('Profile_logout') }}" wire:navigate
                            class="d-flex align-items-center"><i
                                class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.log_out', 'Log Out') }}</a>
                    </li>
                    @else
                    <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#loginModal" class="d-flex align-items-center"><i
                                class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i>{{ labels('front_messages.sign_in', 'Login as Customer') }}</a>
                    </li>
                    <li>
                     <a href="https://solarmart.neuromonk.co.in/seller/login" class="d-flex align-items-center">
                         <i class="anm anm-arrow-al-right anm-user-al hdr-icon icon"></i>{{ labels('front_messages.sign_in', 'Login as Seller') }}
                     </a>
                    </li>
                    <li><a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#registerModal" class="d-flex align-items-center"><i
                                class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.register', 'Register as Customer') }}</a>
                    </li>
                     <li>
                     <a href="https://solarmart.neuromonk.co.in/seller/register" class="d-flex align-items-center">
                         <i class="hdr-icon icon anm anm-user-al"></i>{{ labels('front_messages.sign_in', 'Register as Seller') }}
                     </a>
                    </li>

                    @endauth
                    <li class="title h5">{{ labels('front_messages.need_help', 'Need Help?') }}</li>
                    <li><a href="tel:401234567890" class="d-flex align-items-center"><ion-icon
                                name="call-outline" class="me-1"></ion-icon>
                            {{ $settings->support_number }}</a></li>
                    <li><a href="mailto:info@example.com" class="d-flex align-items-center"><ion-icon
                                name="mail-outline" class="me-1"></ion-icon> {{ $settings->support_email }}</a>
                    </li>
                </ul>
            </div>
            {{--
            <div class="mobile-follow mt-2">
                <h5 class="title">{{ labels('front_messages.follow_us', 'Follow Us') }}</h5>
                <ul class="list-inline social-icons mt-3">
                    @if ($settings->facebook_link !== null)
                            <li class="list-inline-item">
                                <a href="{{ $settings->facebook_link }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="Facebook">

                                    <img src="{{ asset('assets/img/facebook.png') }}"
                                        alt="Facebook"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                            @endif


                        @if ($settings->instagram_link !== null)
                            <li class="list-inline-item">
                                <a href="{{ $settings->instagram_link }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="Instagram">

                                    <img src="{{ asset('assets/img/instagram.png') }}"
                                        alt="Instagram"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                        @endif
                        @if ($settings->youtube_link !== null)
                            <li class="list-inline-item">
                                <a href="{{ $settings->youtube_link }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="YouTube">

                                    <img src="{{ asset('assets/img/youtube.png') }}"
                                        alt="YouTube"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                        @endif
                         @if ($settings->linkedin_link !== null)
                            <li class="list-inline-item">
                                <a href="{{ $settings->linkedin_link }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="LinkedIn">

                                    <img src="{{ asset('assets/img/linkedin.png') }}"
                                        alt="LinkedIn"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                        @endif
                </ul>
            </div>
            --}}
        </li>
    </ul>
</div>
{{-- search --}}
{{--<livewire:header.SearchProduct />--}}


<livewire:pages.model-cart />
@if (isset($stores) &&
count($stores) >= 1 &&
url()->full() == customUrl(url()->full()) &&
session()->get('show_store_popup'))
<div class="newsletter-modal modal fade" id="store_select_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content border-0">
            <div class="modal-body p-0">
                <button type="button" class="btn-close" data-bs-dismiss="modal"
                    aria-label="Close"></button>
                <div class="newsletter-wrap d-flex flex-column">
                    <div class="newsltr-text text-center store-popup-box">
                        <div class="wraptext mw-100">
                            <h6 class="title text-transform-none">
                                {{ labels('front_messages.please_choose_store.', 'Please choose a store.') }}
                            </h6>
                            <p class="text">
                                {{ labels('front_messages.pick_store_that_suits_your_requirements', 'Pick a Store that Suits Your Requirements.') }}
                            </p>
                            <div class="collection-style1 row row-cols-2 row-cols-lg-3 mt-0">
                                @if (count($stores) >= 1)
                                @foreach ($stores as $store)
                                @php
                                $store_img = route('front_end.dynamic_image', [
                                'url' => app(MediaService::class)->getMediaImageUrl(
                                $store->image,
                                'STORE_IMG_PATH',
                                ),
                                'width' => 400,
                                'quality' => 90,
                                ]);
                                $store_name = app(TranslationService::class)->getDynamicTranslation(
                                Store::class,
                                'name',
                                $store->id,
                                $language_code,
                                );
                                @endphp
                                <div class="category-item zoomscal-hov">
                                    <a data-store-id="{{ $store->id }}"
                                        data-store-name="{{ $store_name }}"
                                        data-store-slug="{{ $store->slug }}"
                                        data-store-image="{{ $store_img }}"
                                        class="category-link select-store clr-none cursor-pointer">
                                        <div class="zoom-scal zoom-scal-nopb brands-image">
                                            <img class="blur-up lazyload w-100"
                                                data-src="{{ $store_img }}"
                                                src="{{ $store_img }}" alt="{{ $store_name }}"
                                                title="{{ $store_name }}" />
                                        </div>
                                        <div
                                            class="details mt-3 d-flex justify-content-center align-items-center">
                                            <h4 class="category-title mb-0">
                                                {{ $store_name }}
                                            </h4>
                                        </div>
                                    </a>
                                </div>
                                @endforeach
                                @endif
                            </div>
                            {{-- <div class="customCheckbox checkboxlink clearfix justify-content-center">
                                    <input id="dontshow" name="newsPopup" type="checkbox" />
                                    <label for="dontshow" class="mb-0">Don't show this popup again</label>
                                </div> --}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif
<style>
    #nprogress .bar {
        background: <?= $store_details[0]->secondary_color ?? '#f4a51c' ?> !important;
        z-index: 1111;
    }

    .swiper-pagination-bullet-active-main {
        background: <?= $store_details[0]->secondary_color ?? '#f4a51c' ?> !important;
    }
</style>
<style>
    /* Force body overflow hidden when modal is open */
    body.modal-open-fix {
        overflow: hidden !important;
        height: 100vh !important;
    }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const modals = ['loginModal', 'registerModal'];

    modals.forEach(modalId => {
        const modalEl = document.getElementById(modalId);
        if (modalEl) {
            modalEl.addEventListener('show.bs.modal', function () {
                document.body.classList.add('modal-open-fix');
            });

            modalEl.addEventListener('hidden.bs.modal', function () {
                document.body.classList.remove('modal-open-fix');
            });
        }
    });

        // Use event delegation for mobile search toggles to survive Livewire re-renders
        $(document).on('click', '.search-icon-mobile', function() {
            // Close mobile menu if it's open
            $('.mobile-nav-wrapper').removeClass('active');

            $('.mobile-search-overlay').css('display', 'flex');
            $('body').addClass('modal-open-fix');

            // Focus on search input when opened
            setTimeout(function() {
                $('.mobile-search-overlay input[type="text"]').focus();
            }, 100);
        });

        $(document).on('click', '.search-close-mobile', function() {
            $('.mobile-search-overlay').hide();
            $('body').removeClass('modal-open-fix');
        });

        // Close search overlay when a product is clicked in results
        $(document).on('click', '.mobile-search-body .search-result-item a', function() {
            $('.mobile-search-overlay').hide();
            $('body').removeClass('modal-open-fix');
        });

});
</script>
@if (isset($stores) &&
count($stores) >= 2 &&
url()->full() == customUrl(url()->full()) &&
session()->get('show_store_popup'))
@php
session()->put('show_store_popup', false);
@endphp
<script>
    setTimeout(function() {
        $('#store_select_modal').modal("show");
    }, 2000);
</script>
@endif
</div>
<!-- <script>
function initMobileMenu() {

    const openBtn = document.querySelector(".js-mobile-nav-toggle");
    const mobileWrapper = document.querySelector(".mobile-nav-wrapper");
    const closeBtn = document.querySelector(".closemobileMenu");

    // Remove old listeners by cloning (important fix)
    if (openBtn) {
        const newOpenBtn = openBtn.cloneNode(true);
        openBtn.parentNode.replaceChild(newOpenBtn, openBtn);

        newOpenBtn.addEventListener("click", function () {
            mobileWrapper.classList.add("active");
        });
    }

    if (closeBtn) {
        const newCloseBtn = closeBtn.cloneNode(true);
        closeBtn.parentNode.replaceChild(newCloseBtn, closeBtn);

        newCloseBtn.addEventListener("click", function () {
            mobileWrapper.classList.remove("active");
        });
    }

    // Submenu toggle (multi-level)
    const allLinks = document.querySelectorAll("#MobileNav a");

    allLinks.forEach(function (link) {

        const newLink = link.cloneNode(true);
        link.parentNode.replaceChild(newLink, link);

        newLink.addEventListener("click", function (e) {

            const nextEl = this.nextElementSibling;

            if (nextEl && nextEl.classList.contains("sub-menu")) {
                e.preventDefault();

                if (nextEl.style.display === "block") {
                    nextEl.style.display = "none";
                } else {
                    nextEl.style.display = "block";
                }
            }
        });
    });
}

/* Run first time */
document.addEventListener("DOMContentLoaded", function () {
    initMobileMenu();
});

/* VERY IMPORTANT: run again after Livewire page change */
document.addEventListener("livewire:navigated", function () {
    initMobileMenu();
});
</script> -->
<script>
function initMobileMenu() {

    const openBtn = document.querySelector(".js-mobile-nav-toggle");
    const mobileWrapper = document.querySelector(".mobile-nav-wrapper");
    const closeBtn = document.querySelector(".closemobileMenu");

    // Open menu
    if (openBtn) {
        const newOpenBtn = openBtn.cloneNode(true);
        openBtn.parentNode.replaceChild(newOpenBtn, openBtn);

        newOpenBtn.addEventListener("click", function () {
            mobileWrapper.classList.add("active");
        });
    }

    // Close menu button
    if (closeBtn) {
        const newCloseBtn = closeBtn.cloneNode(true);
        closeBtn.parentNode.replaceChild(newCloseBtn, closeBtn);

        newCloseBtn.addEventListener("click", function () {
            mobileWrapper.classList.remove("active");
        });
    }

    // Handle all menu clicks
    const allLinks = document.querySelectorAll("#MobileNav a");

    allLinks.forEach(function (link) {

        const newLink = link.cloneNode(true);
        link.parentNode.replaceChild(newLink, link);

        newLink.addEventListener("click", function (e) {

            const nextEl = this.nextElementSibling;

            // If submenu exists → toggle only (do not close menu)
            if (nextEl && nextEl.classList.contains("sub-menu")) {
                e.preventDefault();

                if (nextEl.style.display === "block") {
                    nextEl.style.display = "none";
                } else {
                    nextEl.style.display = "block";
                }

            } else {
                // Normal link → close menu after navigation click
                mobileWrapper.classList.remove("active");
            }
        });
    });
}

/* First load */
document.addEventListener("DOMContentLoaded", function () {
    initMobileMenu();
});

/* After Livewire navigation */
document.addEventListener("livewire:navigated", function () {
    initMobileMenu();
});
</script>




