@extends('admin/layout')
@section('title')
    {{ labels('admin_labels.affiliate_users', 'Affiliate Users') }}
@endsection
@section('content')
    <x-admin.breadcrumb :title="labels('admin_labels.affiliate_users', 'Affiliate Users')" :subtitle="labels(
        'admin_labels.efficiently_organize_and_control_affiliate_users',
        'Efficiently Organize and Control Affiliate Users',
    )" :breadcrumbs="[
        ['label' => labels('admin_labels.affiliate_user', 'Affiliate Users'), 'url' => route('admin.affiliate.manage_user')],
        ['label' => labels('admin_labels.update_user', 'Update User')]]" />

    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-info">
                    <div class="mx-5 my-3 stepper-container">
                        <div class="step-wrapper">
                            <div class="affiliate_step" id="step1" onclick="goToStep(1)">
                                <div class="circle"></div>
                                <h5 class="mt-2">{{ labels('admin_labels.account_information', 'Account Information') }}</h5>
                            </div>
                            <div class="bar"></div>
                        </div>
                        <div class="step-wrapper">
                            <div class="affiliate_step" id="step2" onclick="goToStep(2)">
                                <div class="circle"></div>
                                <h5 class="mt-2">{{ labels('admin_labels.website_and_mobile_app_list', 'Website and Mobile App List') }}</h5>
                            </div>
                            <div class="bar"></div>
                        </div>

                        <div class="step-wrapper">
                            <div class="affiliate_step" id="step4" onclick="goToStep(3)">
                                <div class="circle"></div>
                                <h5 class="mt-2">{{ labels('admin_labels.start_using_associates_central', 'Start Using Associates Central') }}</h5>
                            </div>
                        </div>
                    </div>
                    <form class="" id="add_affiliate_user_form" method="POST"
                        action="{{ route('admin.affiliate_users.update', $user->id) }}" novalidate>
                        @csrf
                        @method('PUT')
                        <input type="hidden" name="form_mode" value="update">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                {{-- Step 1 --}}
                                <div class="step-page" id="page1">
                                    <h5 class="mb-4">{{ labels('admin_labels.account_information', 'Account Information') }}</h5>

                                    <div class="row">
                                        {{-- Full Name --}}
                                        <div class="col-md-6 mb-3">
                                            <label for="full_name" class="form-label">{{ labels('admin_labels.full_name', 'Full Name') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" value="{{ old('full_name', $user->username) }}"
                                                class="form-control" id="full_name" name="full_name"
                                                placeholder="Enter Full Name">
                                        </div>

                                        {{-- Email --}}
                                        <div class="col-md-6 mb-3">
                                            <label for="email" class="form-label">{{ labels('admin_labels.email_address', 'Email Address') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" value="{{ old('email', $user->email) }}"
                                                class="form-control" id="email" name="email"
                                                placeholder="Enter Email">
                                        </div>
                                    </div>

                                    <div class="row">
                                        {{-- Mobile --}}
                                        <div class="col-md-6 mb-3">
                                            <label for="mobile" class="form-label">{{ labels('admin_labels.mobile', 'Mobile') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="mobile" name="mobile"
                                                maxlength="16" placeholder="Enter Mobile"
                                                value="{{ old('mobile', $user->mobile) }}"
                                                oninput="validateNumberInput(this)">
                                        </div>
                                        {{-- Address --}}
                                        <div class="col-md-6 mb-3">
                                            <label for="address" class="form-label">{{ labels('admin_labels.address', 'Address') }} <span
                                                    class="text-danger">*</span></label>
                                            <textarea class="form-control" id="address" name="address" rows="3" placeholder="Enter Address">{{ old('address', $user->address) }}</textarea>
                                        </div>

                                    </div>
                                    <div class="d-flex justify-content-end">
                                        <button type="button" class="btn btn-primary" onclick="nextStep(2)">{{ labels('admin_labels.next', 'Next') }}</button>
                                    </div>
                                </div>

                                {{-- Step 2 --}}
                                <div class="step-page d-none" id="page2">
                                    <h5 class="mb-4">{{ labels('admin_labels.your_websites_and_mobile_apps', 'Your Websites and Mobile Apps') }}</h5>

                                    <div class="row">
                                        {{-- Website --}}
                                        <div class="col-md-6 mb-3">
                                            <label for="website_url" class="form-label">{{ labels('admin_labels.website', 'Website') }} <span
                                                    class="text-danger">*</span></label>
                                            <input type="url" class="form-control" id="website_url"
                                                value="{{ old('website_url', $user->affiliateUser->website_url ?? '') }}"
                                                name="website_url" placeholder="https://www.example.com/myblog">
                                        </div>

                                        {{-- Mobile App --}}
                                        <div class="col-md-6 mb-3">
                                            <label for="application_url" class="form-label">{{ labels('admin_labels.mobile_app', 'Mobile App') }}<span
                                                    class="text-danger">*</span></label>
                                            <input type="url" class="form-control" id="application_url"
                                                value="{{ old('application_url', $user->affiliateUser->application_url ?? '') }}"
                                                name="application_url" placeholder="https://xxxx/dp/xxxx">
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between">
                                        <button type="button" class="btn btn-secondary"
                                            onclick="prevStep(1)">Previous</button>
                                        <button type="button" class="btn btn-primary"
                                            onclick="nextStep(3)">Next</button>
                                    </div>
                                </div>

                                {{-- Step 3 --}}
                                <div class="step-page d-none" id="page3">
                                    <h5 class="mb-4">{{ labels('admin_labels.start_using_associates_central', 'Start Using Associates Central') }}</h5>

                                    <div class="mb-3">
                                        <label class="form-label">{{ labels('admin_labels.status', 'Status') }} <span class="text-danger">*</span></label>
                                        <div class="d-flex gap-4">
                                            @php $status = old('status', $user->affiliateUser->status ?? '') @endphp
                                            @foreach (['0' => 'Deactive', '1' => 'Approved', '2' => 'Not-Approved'] as $value => $label)
                                                <input class="form-check-input" type="radio" name="status"
                                                    id="status_{{ $value }}" value="{{ $value }}"
                                                    {{ $status == $value ? 'checked' : '' }}>
                                                <label class="form-check-label"
                                                    for="status_{{ $value }}">{{ $label }}</label>
                                            @endforeach
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between">
                                        <button type="button" class="btn btn-secondary"
                                            onclick="prevStep(2)">{{ labels('admin_labels.previous', 'Previous') }}</button>
                                        <button type="submit" class="btn btn-primary submit_button">{{ labels('admin_labels.update_user', 'Update User') }}</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
