import { Options } from "../../core";
import { Any, AnyObject, Callback, TimeUnit, WindowOperatorInput } from "../../types";
export type WindowTimeUnit = Exclude<TimeUnit, "year" | "quarter" | "month">;
export declare const MILLIS_PER_UNIT: Record<WindowTimeUnit, number>;
/**
 * Caches all computed values in a window sequence for reuse.
 * This is only useful for operations with unbounded documents.
 */
export declare function withMemo<T = Any, R = Any>(collection: AnyObject[], expr: WindowOperatorInput, cacheFn: Callback<T>, fn: Callback<R, T>): R;
/** Returns the position of a document in the $setWindowFields stage partition. */
export declare function rank(_: AnyObject, collection: AnyObject[], expr: WindowOperatorInput, options: Options, dense: boolean): Any;
