import { Options } from "./core";
import { Iterator, Source } from "./lazy";
import { AnyObject } from "./types";
/**
 * Provides functionality for the mongoDB aggregation pipeline
 *
 * @param pipeline an Array of pipeline operators
 * @param options An optional Options to pass the aggregator
 * @constructor
 */
export declare class Aggregator {
    #private;
    constructor(pipeline: AnyObject[], options?: Partial<Options>);
    /**
     * Returns an {@link Iterator} for lazy evaluation of the pipeline.
     *
     * @param collection An array or iterator object
     * @returns {Iterator} an iterator object
     */
    stream(collection: Source, options?: Options): Iterator;
    /**
     * Return the results of the aggregation as an array.
     *
     * @param collection
     */
    run<T extends AnyObject>(collection: Source, options?: Options): T[];
}
