import * as UPDATE_OPERATORS from "./operators/update";
import { UPDATE_OPTIONS } from "./operators/update/_internal";
import { Query } from "./query";
import { assert, has } from "./util";
function createUpdater(defaultOptions) {
  defaultOptions = defaultOptions ?? UPDATE_OPTIONS;
  return (obj, expr, arrayFilters = [], condition = {}, options = defaultOptions) => {
    const entry = Object.entries(expr);
    assert(
      entry.length === 1,
      "Update expression must contain only one operator."
    );
    const [op, args] = entry[0];
    assert(
      has(UPDATE_OPERATORS, op),
      `Update operator '${op}' is not supported.`
    );
    const mutate = UPDATE_OPERATORS[op];
    if (Object.keys(condition).length) {
      const q = new Query(condition, options.queryOptions);
      if (!q.test(obj)) return [];
    }
    return mutate(obj, args, arrayFilters, options);
  };
}
const update = createUpdater();
const updateObject = update;
export {
  createUpdater,
  update,
  updateObject
};
