import { computeValue } from "../../../core";
import { assert, isNil, isString } from "../../../util";
const $concat = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  assert(
    args.every((v) => isString(v) || isNil(v)),
    "$concat only supports strings."
  );
  if (args.some(isNil)) return null;
  return args.join("");
};
export {
  $concat
};
