import { computeValue } from "../../../core";
import { assert, isArray, ValueMap } from "../../../util";
const $setEquals = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  assert(
    isArray(args) && args.every(isArray),
    "$setEquals operands must be arrays."
  );
  const map = ValueMap.init();
  args[0].every((v, i) => map.set(v, i));
  for (let i = 1; i < args.length; i++) {
    const arr = args[i];
    const set = /* @__PURE__ */ new Set();
    for (let j = 0; j < arr.length; j++) {
      const n = map.get(arr[j]) ?? -1;
      if (n === -1) return false;
      set.add(n);
    }
    if (set.size !== map.size) return false;
  }
  return true;
};
export {
  $setEquals
};
