import { computeValue } from "../../../core";
import { assert, isNil, isObject, isString } from "../../../util";
const $setField = (obj, expr, options) => {
  const { input, field, value } = computeValue(
    obj,
    expr,
    null,
    options
  );
  if (isNil(input)) return null;
  assert(
    isObject(input),
    "$setField expression 'input' must evaluate to an object"
  );
  assert(
    isString(field),
    "$setField expression 'field' must evaluate to a string"
  );
  const newObj = { ...input };
  if (expr.value == "$$REMOVE") {
    delete newObj[field];
  } else {
    newObj[field] = value;
  }
  return newObj;
};
export {
  $setField
};
