import { computeValue } from "../../../core";
import { Lazy } from "../../../lazy";
import { assert, compare, isArray, isNil, isObject } from "../../../util";
import { $sort } from "../../pipeline/sort";
const $sortArray = (obj, expr, options) => {
  const { input, sortBy } = computeValue(obj, expr, null, options);
  if (isNil(input)) return null;
  assert(isArray(input), "$sortArray expression must resolve to an array");
  if (isObject(sortBy)) {
    return $sort(Lazy(input), sortBy, options).value();
  }
  const result = [...input];
  result.sort(compare);
  if (sortBy === -1) result.reverse();
  return result;
};
export {
  $sortArray
};
