import { computeValue } from "../../../core";
import { assert, flatten, isArray, isNil } from "../../../util";
import { $last as __last } from "../../accumulator/last";
const $last = (obj, expr, options) => {
  if (isArray(obj)) return __last(obj, expr, options);
  const arr = computeValue(obj, expr, null, options);
  if (isNil(arr)) return null;
  assert(
    isArray(arr) && arr.length > 0,
    "$last must resolve to a non-empty array."
  );
  return flatten(arr)[arr.length - 1];
};
export {
  $last
};
