import { computeValue } from "../../../core";
import { assert, isArray, isNil } from "../../../util";
const $concatArrays = (obj, expr, options) => {
  const nArray = computeValue(obj, expr, null, options);
  assert(isArray(nArray), "$concatArrays: input must resolve to an array");
  let size = 0;
  for (const arr of nArray) {
    if (isNil(arr)) return null;
    size += arr.length;
  }
  const result = new Array(size);
  let i = 0;
  for (const arr of nArray) for (const item of arr) result[i++] = item;
  return result;
};
export {
  $concatArrays
};
