import { computeValue } from "../../../core";
import { assert, isDate } from "../../../util";
const $add = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  let hasDate = false;
  let sum = 0;
  for (const n of args) {
    if (isDate(n)) {
      assert(!hasDate, "'$add' can only have one date value");
      hasDate = true;
    }
    sum += +n;
  }
  return hasDate ? new Date(sum) : sum;
};
export {
  $add
};
