function stddev(data, sampled = true) {
  const sum = data.reduce((acc, n) => acc + n, 0);
  const N = data.length || 1;
  const avg = sum / N;
  return Math.sqrt(
    data.reduce((acc, n) => acc + Math.pow(n - avg, 2), 0) / (N - Number(sampled))
  );
}
function covariance(dataset, sampled = true) {
  if (!dataset) return null;
  if (dataset.length < 2) return sampled ? null : 0;
  let meanX = 0;
  let meanY = 0;
  for (const [x, y] of dataset) {
    meanX += x;
    meanY += y;
  }
  meanX /= dataset.length;
  meanY /= dataset.length;
  let result = 0;
  for (const [x, y] of dataset) {
    result += (x - meanX) * (y - meanY);
  }
  return result / (dataset.length - Number(sampled));
}
export {
  covariance,
  stddev
};
