var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var bucket_exports = {};
__export(bucket_exports, {
  $bucket: () => $bucket
});
module.exports = __toCommonJS(bucket_exports);
var import_core = require("../../core");
var import_lazy = require("../../lazy");
var import_util = require("../../util");
const $bucket = (collection, expr, options) => {
  const bounds = [...expr.boundaries];
  const defaultKey = expr.default;
  const lower = bounds[0];
  const upper = bounds[bounds.length - 1];
  const outputExpr = expr.output || { count: { $sum: 1 } };
  (0, import_util.assert)(bounds.length > 1, "$bucket must specify at least two boundaries.");
  const isValid = bounds.every(
    (v, i) => i === 0 || (0, import_util.typeOf)(v) === (0, import_util.typeOf)(bounds[i - 1]) && (0, import_util.compare)(v, bounds[i - 1]) > 0
  );
  (0, import_util.assert)(
    isValid,
    `$bucket: bounds must be of same type and in ascending order`
  );
  if (!(0, import_util.isNil)(defaultKey) && (0, import_util.typeOf)(defaultKey) === (0, import_util.typeOf)(lower)) {
    (0, import_util.assert)(
      (0, import_util.compare)(defaultKey, upper) >= 0 || (0, import_util.compare)(defaultKey, lower) < 0,
      "$bucket 'default' expression must be out of boundaries range"
    );
  }
  const createBuckets = () => {
    const buckets = /* @__PURE__ */ new Map();
    for (let i = 0; i < bounds.length - 1; i++) {
      buckets.set(bounds[i], []);
    }
    if (!(0, import_util.isNil)(defaultKey)) buckets.set(defaultKey, []);
    collection.each((obj) => {
      const key = (0, import_core.computeValue)(obj, expr.groupBy, null, options);
      if ((0, import_util.isNil)(key) || (0, import_util.compare)(key, lower) < 0 || (0, import_util.compare)(key, upper) >= 0) {
        (0, import_util.assert)(
          !(0, import_util.isNil)(defaultKey),
          "$bucket require a default for out of range values"
        );
        buckets.get(defaultKey).push(obj);
      } else {
        (0, import_util.assert)(
          (0, import_util.compare)(key, lower) >= 0 && (0, import_util.compare)(key, upper) < 0,
          "$bucket 'groupBy' expression must resolve to a value in range of boundaries"
        );
        const index = (0, import_util.findInsertIndex)(bounds, key);
        const boundKey = bounds[Math.max(0, index - 1)];
        buckets.get(boundKey).push(obj);
      }
    });
    bounds.pop();
    if (!(0, import_util.isNil)(defaultKey)) bounds.push(defaultKey);
    (0, import_util.assert)(
      buckets.size === bounds.length,
      "bounds and groups must be of equal size."
    );
    return (0, import_lazy.Lazy)(bounds).map((key) => {
      return {
        ...(0, import_core.computeValue)(
          buckets.get(key),
          outputExpr,
          null,
          options
        ),
        _id: key
      };
    });
  };
  let iterator;
  return (0, import_lazy.Lazy)(() => {
    if (!iterator) iterator = createBuckets();
    return iterator.next();
  });
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  $bucket
});
