var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var setEquals_exports = {};
__export(setEquals_exports, {
  $setEquals: () => $setEquals
});
module.exports = __toCommonJS(setEquals_exports);
var import_core = require("../../../core");
var import_util = require("../../../util");
const $setEquals = (obj, expr, options) => {
  const args = (0, import_core.computeValue)(obj, expr, null, options);
  (0, import_util.assert)(
    (0, import_util.isArray)(args) && args.every(import_util.isArray),
    "$setEquals operands must be arrays."
  );
  const map = import_util.ValueMap.init();
  args[0].every((v, i) => map.set(v, i));
  for (let i = 1; i < args.length; i++) {
    const arr = args[i];
    const set = /* @__PURE__ */ new Set();
    for (let j = 0; j < arr.length; j++) {
      const n = map.get(arr[j]) ?? -1;
      if (n === -1) return false;
      set.add(n);
    }
    if (set.size !== map.size) return false;
  }
  return true;
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  $setEquals
});
