var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var aggregator_exports = {};
__export(aggregator_exports, {
  Aggregator: () => Aggregator
});
module.exports = __toCommonJS(aggregator_exports);
var import_core = require("./core");
var import_lazy = require("./lazy");
var import_util = require("./util");
class Aggregator {
  #pipeline;
  #options;
  constructor(pipeline, options) {
    this.#pipeline = pipeline;
    this.#options = (0, import_core.initOptions)(options);
  }
  /**
   * Returns an {@link Iterator} for lazy evaluation of the pipeline.
   *
   * @param collection An array or iterator object
   * @returns {Iterator} an iterator object
   */
  stream(collection, options) {
    let iter = (0, import_lazy.Lazy)(collection);
    const opts = options ?? this.#options;
    const mode = opts.processingMode;
    if (mode & import_core.ProcessingMode.CLONE_INPUT) iter.map(import_util.cloneDeep);
    const stages = new Array();
    if (!(0, import_util.isEmpty)(this.#pipeline)) {
      for (const opExpr of this.#pipeline) {
        const opKeys = Object.keys(opExpr);
        const opName = opKeys[0];
        const call = (0, import_core.getOperator)("pipeline", opName, opts);
        (0, import_util.assert)(
          opKeys.length === 1 && !!call,
          `invalid pipeline operator ${opName}`
        );
        stages.push(opName);
        iter = call(iter, opExpr[opName], opts);
      }
    }
    if (mode & import_core.ProcessingMode.CLONE_OUTPUT) iter.map(import_util.cloneDeep);
    return iter;
  }
  /**
   * Return the results of the aggregation as an array.
   *
   * @param collection
   */
  run(collection, options) {
    return this.stream(collection, options).value();
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Aggregator
});
