var $c1905b78f6d2f5bf$exports = require("./intlStrings.main.js");
var $4acc2f407c169e55$exports = require("./useDateField.main.js");
var $715562ad3b4cced4$exports = require("./useDatePickerGroup.main.js");
var $bxHoL$reactariafocus = require("@react-aria/focus");
var $bxHoL$reactariautils = require("@react-aria/utils");
var $bxHoL$reactstatelyform = require("@react-stately/form");
var $bxHoL$reactarialabel = require("@react-aria/label");
var $bxHoL$reactariainteractions = require("@react-aria/interactions");
var $bxHoL$reactariai18n = require("@react-aria/i18n");
var $bxHoL$react = require("react");


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}

function $parcel$export(e, n, v, s) {
  Object.defineProperty(e, n, {get: v, set: s, enumerable: true, configurable: true});
}

$parcel$export(module.exports, "useDatePicker", () => $e90ae7c26a69c6b1$export$42df105a73306d51);
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 









function $e90ae7c26a69c6b1$export$42df105a73306d51(props, state, ref) {
    let buttonId = (0, $bxHoL$reactariautils.useId)();
    let dialogId = (0, $bxHoL$reactariautils.useId)();
    let fieldId = (0, $bxHoL$reactariautils.useId)();
    let stringFormatter = (0, $bxHoL$reactariai18n.useLocalizedStringFormatter)((0, ($parcel$interopDefault($c1905b78f6d2f5bf$exports))), '@react-aria/datepicker');
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $bxHoL$reactarialabel.useField)({
        ...props,
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    let groupProps = (0, $715562ad3b4cced4$exports.useDatePickerGroup)(state, ref);
    let labelledBy = fieldProps['aria-labelledby'] || fieldProps.id;
    let { locale: locale } = (0, $bxHoL$reactariai18n.useLocale)();
    let date = state.formatValue(locale, {
        month: 'long'
    });
    let description = date ? stringFormatter.format('selectedDateDescription', {
        date: date
    }) : '';
    let descProps = (0, $bxHoL$reactariautils.useDescription)(description);
    let ariaDescribedBy = [
        descProps['aria-describedby'],
        fieldProps['aria-describedby']
    ].filter(Boolean).join(' ') || undefined;
    let domProps = (0, $bxHoL$reactariautils.filterDOMProps)(props);
    let focusManager = (0, $bxHoL$react.useMemo)(()=>(0, $bxHoL$reactariafocus.createFocusManager)(ref), [
        ref
    ]);
    let { focusWithinProps: focusWithinProps } = (0, $bxHoL$reactariainteractions.useFocusWithin)({
        ...props,
        isDisabled: state.isOpen,
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    return {
        groupProps: (0, $bxHoL$reactariautils.mergeProps)(domProps, groupProps, fieldProps, descProps, focusWithinProps, {
            role: 'group',
            'aria-disabled': props.isDisabled || null,
            'aria-labelledby': labelledBy,
            'aria-describedby': ariaDescribedBy,
            onKeyDown (e) {
                if (state.isOpen) return;
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (state.isOpen) return;
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        fieldProps: {
            ...fieldProps,
            id: fieldId,
            [(0, $4acc2f407c169e55$exports.roleSymbol)]: 'presentation',
            'aria-describedby': ariaDescribedBy,
            value: state.value,
            onChange: state.setValue,
            placeholderValue: props.placeholderValue,
            hideTimeZone: props.hideTimeZone,
            hourCycle: props.hourCycle,
            shouldForceLeadingZeros: props.shouldForceLeadingZeros,
            granularity: props.granularity,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isRequired: props.isRequired,
            validationBehavior: props.validationBehavior,
            // DatePicker owns the validation state for the date field.
            [(0, $bxHoL$reactstatelyform.privateValidationStateProp)]: state,
            autoFocus: props.autoFocus,
            name: props.name
        },
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        buttonProps: {
            ...descProps,
            id: buttonId,
            'aria-haspopup': 'dialog',
            'aria-label': stringFormatter.format('calendar'),
            'aria-labelledby': `${buttonId} ${labelledBy}`,
            'aria-describedby': ariaDescribedBy,
            'aria-expanded': state.isOpen,
            isDisabled: props.isDisabled || props.isReadOnly,
            onPress: ()=>state.setOpen(true)
        },
        dialogProps: {
            id: dialogId,
            'aria-labelledby': `${buttonId} ${labelledBy}`
        },
        calendarProps: {
            autoFocus: true,
            value: state.dateValue,
            onChange: state.setDateValue,
            minValue: props.minValue,
            maxValue: props.maxValue,
            isDisabled: props.isDisabled,
            isReadOnly: props.isReadOnly,
            isDateUnavailable: props.isDateUnavailable,
            defaultFocusedValue: state.dateValue ? undefined : props.placeholderValue,
            isInvalid: state.isInvalid,
            errorMessage: typeof props.errorMessage === 'function' ? props.errorMessage(state.displayValidation) : props.errorMessage || state.displayValidation.validationErrors.join(' ')
        },
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}


//# sourceMappingURL=useDatePicker.main.js.map
