import {checkboxGroupData as $1ae600c947479353$export$ec98120685d4f57d} from "./utils.mjs";
import {filterDOMProps as $gtLuF$filterDOMProps, mergeProps as $gtLuF$mergeProps} from "@react-aria/utils";
import {useField as $gtLuF$useField} from "@react-aria/label";
import {useFocusWithin as $gtLuF$useFocusWithin} from "@react-aria/interactions";

/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 



function $1e9fce0cfacc738b$export$49ff6f28c54f1cbe(props, state) {
    let { isDisabled: isDisabled, name: name, validationBehavior: validationBehavior = 'aria' } = props;
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $gtLuF$useField)({
        ...props,
        // Checkbox group is not an HTML input element so it
        // shouldn't be labeled by a <label> element.
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    (0, $1ae600c947479353$export$ec98120685d4f57d).set(state, {
        name: name,
        descriptionId: descriptionProps.id,
        errorMessageId: errorMessageProps.id,
        validationBehavior: validationBehavior
    });
    let domProps = (0, $gtLuF$filterDOMProps)(props, {
        labelable: true
    });
    let { focusWithinProps: focusWithinProps } = (0, $gtLuF$useFocusWithin)({
        onBlurWithin: props.onBlur,
        onFocusWithin: props.onFocus,
        onFocusWithinChange: props.onFocusChange
    });
    return {
        groupProps: (0, $gtLuF$mergeProps)(domProps, {
            role: 'group',
            'aria-disabled': isDisabled || undefined,
            ...fieldProps,
            ...focusWithinProps
        }),
        labelProps: labelProps,
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}


export {$1e9fce0cfacc738b$export$49ff6f28c54f1cbe as useCheckboxGroup};
//# sourceMappingURL=useCheckboxGroup.module.js.map
