import {
  useMultiSelectListState
} from "./chunk-RVB7J7GX.mjs";

// src/use-multiselect-state.ts
import { useMenuTriggerState } from "@react-stately/menu";
import { useFormValidationState } from "@react-stately/form";
import { useState } from "react";
function useMultiSelectState({
  validate,
  validationBehavior,
  ...props
}) {
  const [isFocused, setFocused] = useState(false);
  const [focusStrategy, setFocusStrategy] = useState(null);
  const triggerState = useMenuTriggerState(props);
  const listState = useMultiSelectListState({
    ...props,
    onSelectionChange: (keys) => {
      if (props.onSelectionChange != null) {
        if (keys === "all") {
          props.onSelectionChange(new Set(listState.collection.getKeys()));
        } else {
          props.onSelectionChange(keys);
        }
      }
      if (props.selectionMode === "single") {
        triggerState.close();
      }
    }
  });
  const validationState = useFormValidationState({
    ...props,
    validationBehavior,
    validate: (value) => {
      if (!validate)
        return;
      const keys = Array.from(value);
      return validate(props.selectionMode === "single" ? keys[0] : keys);
    },
    value: listState.selectedKeys
  });
  const shouldHideContent = listState.collection.size === 0 && props.hideEmptyContent;
  return {
    ...validationState,
    ...listState,
    ...triggerState,
    focusStrategy,
    close() {
      triggerState.close();
    },
    open(focusStrategy2 = null) {
      if (shouldHideContent)
        return;
      setFocusStrategy(focusStrategy2);
      triggerState.open();
    },
    toggle(focusStrategy2 = null) {
      if (shouldHideContent)
        return;
      setFocusStrategy(focusStrategy2);
      triggerState.toggle();
    },
    isFocused,
    setFocused
  };
}

export {
  useMultiSelectState
};
