"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/tab.tsx
var tab_exports = {};
__export(tab_exports, {
  default: () => tab_default
});
module.exports = __toCommonJS(tab_exports);
var import_system = require("@nextui-org/system");
var import_react_utils = require("@nextui-org/react-utils");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_utils = require("@react-aria/utils");
var import_scroll_into_view_if_needed = __toESM(require("scroll-into-view-if-needed"));
var import_focus = require("@react-aria/focus");
var import_tabs = require("@react-aria/tabs");
var import_interactions = require("@react-aria/interactions");
var import_framer_motion = require("framer-motion");
var import_use_is_mounted = require("@nextui-org/use-is-mounted");
var import_jsx_runtime = require("react/jsx-runtime");
var Tab = (0, import_system.forwardRef)((props, ref) => {
  var _a;
  const {
    className,
    as,
    item,
    state,
    classNames,
    isDisabled: isDisabledProp,
    listRef,
    slots,
    motionProps,
    disableAnimation,
    disableCursorAnimation,
    shouldSelectOnPressUp,
    onClick,
    tabRef,
    ...otherProps
  } = props;
  const { key } = item;
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const Component = as || (props.href ? "a" : "button");
  const shouldFilterDOMProps = typeof Component === "string";
  const {
    tabProps,
    isSelected,
    isDisabled: isDisabledItem,
    isPressed
  } = (0, import_tabs.useTab)({ key, isDisabled: isDisabledProp, shouldSelectOnPressUp }, state, domRef);
  if (props.children == null) {
    delete tabProps["aria-controls"];
  }
  const isDisabled = isDisabledProp || isDisabledItem;
  const { focusProps, isFocused, isFocusVisible } = (0, import_focus.useFocusRing)();
  const { hoverProps, isHovered } = (0, import_interactions.useHover)({
    isDisabled
  });
  const tabStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.tab, className);
  const [, isMounted] = (0, import_use_is_mounted.useIsMounted)({
    rerender: true
  });
  const handleClick = () => {
    (0, import_utils.chain)(onClick, tabProps.onClick);
    if (!(domRef == null ? void 0 : domRef.current) || !(listRef == null ? void 0 : listRef.current))
      return;
    (0, import_scroll_into_view_if_needed.default)(domRef.current, {
      scrollMode: "if-needed",
      behavior: "smooth",
      block: "end",
      inline: "end",
      boundary: listRef == null ? void 0 : listRef.current
    });
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    Component,
    {
      ref: (0, import_react_utils.mergeRefs)(domRef, tabRef),
      "data-disabled": (0, import_shared_utils.dataAttr)(isDisabledItem),
      "data-focus": (0, import_shared_utils.dataAttr)(isFocused),
      "data-focus-visible": (0, import_shared_utils.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils.dataAttr)(isHovered),
      "data-hover-unselected": (0, import_shared_utils.dataAttr)((isHovered || isPressed) && !isSelected),
      "data-pressed": (0, import_shared_utils.dataAttr)(isPressed),
      "data-selected": (0, import_shared_utils.dataAttr)(isSelected),
      "data-slot": "tab",
      ...(0, import_utils.mergeProps)(
        tabProps,
        !isDisabled ? {
          ...focusProps,
          ...hoverProps
        } : {},
        (0, import_react_utils.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps,
          omitPropNames: /* @__PURE__ */ new Set(["title"])
        }),
        { onClick: handleClick }
      ),
      className: (_a = slots.tab) == null ? void 0 : _a.call(slots, { class: tabStyles }),
      title: otherProps == null ? void 0 : otherProps.titleValue,
      type: Component === "button" ? "button" : void 0,
      children: [
        isSelected && !disableAnimation && !disableCursorAnimation && isMounted ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.LazyMotion, { features: import_framer_motion.domMax, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_framer_motion.m.span,
          {
            className: slots.cursor({ class: classNames == null ? void 0 : classNames.cursor }),
            "data-slot": "cursor",
            layoutDependency: false,
            layoutId: "cursor",
            transition: {
              type: "spring",
              bounce: 0.15,
              duration: 0.5
            },
            ...motionProps
          }
        ) }) : null,
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          "div",
          {
            className: slots.tabContent({
              class: classNames == null ? void 0 : classNames.tabContent
            }),
            "data-slot": "tabContent",
            children: item.rendered
          }
        )
      ]
    }
  );
});
Tab.displayName = "NextUI.Tab";
var tab_default = Tab;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
