"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/tab-panel.tsx
var tab_panel_exports = {};
__export(tab_panel_exports, {
  default: () => tab_panel_default
});
module.exports = __toCommonJS(tab_panel_exports);
var import_system = require("@nextui-org/system");
var import_react_utils = require("@nextui-org/react-utils");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_utils = require("@react-aria/utils");
var import_tabs = require("@react-aria/tabs");
var import_focus = require("@react-aria/focus");
var import_jsx_runtime = require("react/jsx-runtime");
var TabPanel = (0, import_system.forwardRef)((props, ref) => {
  var _a, _b;
  const { as, tabKey, destroyInactiveTabPanel, state, className, slots, classNames, ...otherProps } = props;
  const Component = as || "div";
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const { tabPanelProps } = (0, import_tabs.useTabPanel)({ ...props, id: String(tabKey) }, state, domRef);
  const { focusProps, isFocused, isFocusVisible } = (0, import_focus.useFocusRing)();
  const selectedItem = state.selectedItem;
  const content = state.collection.getItem(tabKey).props.children;
  const tabPanelStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.panel, className, (_a = selectedItem == null ? void 0 : selectedItem.props) == null ? void 0 : _a.className);
  const isSelected = tabKey === (selectedItem == null ? void 0 : selectedItem.key);
  if (!content || !isSelected && destroyInactiveTabPanel) {
    return null;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    Component,
    {
      ref: domRef,
      "data-focus": isFocused,
      "data-focus-visible": isFocusVisible,
      "data-inert": !isSelected ? "true" : void 0,
      inert: (0, import_shared_utils.getInertValue)(!isSelected),
      ...isSelected && (0, import_utils.mergeProps)(tabPanelProps, focusProps, otherProps),
      className: (_b = slots.panel) == null ? void 0 : _b.call(slots, { class: tabPanelStyles }),
      "data-slot": "panel",
      children: content
    }
  );
});
TabPanel.displayName = "NextUI.TabPanel";
var tab_panel_default = TabPanel;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
