"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/table.tsx
var table_exports = {};
__export(table_exports, {
  default: () => table_default
});
module.exports = __toCommonJS(table_exports);
var import_react6 = require("react");
var import_spacer = require("@nextui-org/spacer");
var import_system10 = require("@nextui-org/system");

// src/use-table.ts
var import_react = require("react");
var import_table = require("@react-stately/table");
var import_table2 = require("@react-aria/table");
var import_system = require("@nextui-org/system");
var import_theme = require("@nextui-org/theme");
var import_react_utils = require("@nextui-org/react-utils");
var import_utils = require("@react-aria/utils");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_react2 = require("react");
function useTable(originalProps) {
  var _a;
  const globalContext = (0, import_system.useProviderContext)();
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.table.variantKeys);
  const {
    ref,
    as,
    baseRef,
    children,
    className,
    classNames,
    removeWrapper = false,
    disableAnimation = (_a = globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _a : false,
    isKeyboardNavigationDisabled = false,
    selectionMode = "none",
    topContentPlacement = "inside",
    bottomContentPlacement = "inside",
    selectionBehavior = selectionMode === "none" ? null : "toggle",
    disabledBehavior = "selection",
    showSelectionCheckboxes = selectionMode === "multiple" && selectionBehavior !== "replace",
    BaseComponent = "div",
    checkboxesProps,
    topContent,
    bottomContent,
    onRowAction,
    onCellAction,
    ...otherProps
  } = props;
  const Component = as || "table";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const domBaseRef = (0, import_react_utils.useDOMRef)(baseRef);
  const state = (0, import_table.useTableState)({
    ...originalProps,
    children,
    showSelectionCheckboxes
  });
  if (isKeyboardNavigationDisabled && !state.isKeyboardNavigationDisabled) {
    state.setKeyboardNavigationDisabled(true);
  }
  const { collection } = state;
  const { layout, ...otherOriginalProps } = originalProps;
  const { gridProps } = (0, import_table2.useTable)({ ...otherOriginalProps }, state, domRef);
  const isSelectable = selectionMode !== "none";
  const isMultiSelectable = selectionMode === "multiple";
  const slots = (0, import_react2.useMemo)(
    () => (0, import_theme.table)({
      ...variantProps,
      isSelectable,
      isMultiSelectable
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps), isSelectable, isMultiSelectable]
  );
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const values = (0, import_react2.useMemo)(
    () => {
      var _a2;
      return {
        state,
        slots,
        isSelectable,
        collection,
        classNames,
        color: originalProps == null ? void 0 : originalProps.color,
        disableAnimation,
        checkboxesProps,
        isHeaderSticky: (_a2 = originalProps == null ? void 0 : originalProps.isHeaderSticky) != null ? _a2 : false,
        selectionMode,
        selectionBehavior,
        disabledBehavior,
        showSelectionCheckboxes,
        onRowAction,
        onCellAction
      };
    },
    [
      slots,
      state,
      collection,
      isSelectable,
      classNames,
      selectionMode,
      selectionBehavior,
      checkboxesProps,
      disabledBehavior,
      disableAnimation,
      showSelectionCheckboxes,
      originalProps == null ? void 0 : originalProps.color,
      originalProps == null ? void 0 : originalProps.isHeaderSticky,
      onRowAction,
      onCellAction
    ]
  );
  const getBaseProps = (0, import_react.useCallback)(
    (props2) => ({
      ...props2,
      ref: domBaseRef,
      className: slots.base({ class: (0, import_shared_utils.clsx)(baseStyles, props2 == null ? void 0 : props2.className) })
    }),
    [baseStyles, slots]
  );
  const getWrapperProps = (0, import_react.useCallback)(
    (props2) => ({
      ...props2,
      ref: domBaseRef,
      className: slots.wrapper({ class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.wrapper, props2 == null ? void 0 : props2.className) })
    }),
    [classNames == null ? void 0 : classNames.wrapper, slots]
  );
  const getTableProps = (0, import_react.useCallback)(
    (props2) => ({
      ...(0, import_utils.mergeProps)(
        gridProps,
        (0, import_react_utils.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        props2
      ),
      onKeyDownCapture: void 0,
      ref: domRef,
      className: slots.table({ class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.table, props2 == null ? void 0 : props2.className) })
    }),
    [classNames == null ? void 0 : classNames.table, shouldFilterDOMProps, slots, gridProps, otherProps]
  );
  return {
    BaseComponent,
    Component,
    children,
    state,
    collection,
    values,
    topContent,
    bottomContent,
    removeWrapper,
    topContentPlacement,
    bottomContentPlacement,
    getBaseProps,
    getWrapperProps,
    getTableProps
  };
}

// src/table-row-group.tsx
var import_system2 = require("@nextui-org/system");
var import_react_utils2 = require("@nextui-org/react-utils");
var import_shared_utils2 = require("@nextui-org/shared-utils");
var import_table3 = require("@react-aria/table");
var import_utils2 = require("@react-aria/utils");
var import_jsx_runtime = require("react/jsx-runtime");
var TableRowGroup = (0, import_system2.forwardRef)((props, ref) => {
  var _a;
  const { as, className, children, slots, classNames, ...otherProps } = props;
  const Component = as || "thead";
  const domRef = (0, import_react_utils2.useDOMRef)(ref);
  const { rowGroupProps } = (0, import_table3.useTableRowGroup)();
  const theadStyles = (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.thead, className);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    Component,
    {
      ref: domRef,
      className: (_a = slots.thead) == null ? void 0 : _a.call(slots, { class: theadStyles }),
      ...(0, import_utils2.mergeProps)(rowGroupProps, otherProps),
      children
    }
  );
});
TableRowGroup.displayName = "NextUI.TableRowGroup";
var table_row_group_default = TableRowGroup;

// src/table-header-row.tsx
var import_system3 = require("@nextui-org/system");
var import_react_utils3 = require("@nextui-org/react-utils");
var import_shared_utils3 = require("@nextui-org/shared-utils");
var import_table4 = require("@react-aria/table");
var import_utils3 = require("@react-aria/utils");
var import_jsx_runtime2 = require("react/jsx-runtime");
var TableHeaderRow = (0, import_system3.forwardRef)((props, ref) => {
  var _a, _b;
  const { as, className, children, node, slots, classNames, state, ...otherProps } = props;
  const Component = as || "tr";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const { rowProps } = (0, import_table4.useTableHeaderRow)({ node }, state, domRef);
  const trStyles = (0, import_shared_utils3.clsx)(classNames == null ? void 0 : classNames.tr, className, (_a = node.props) == null ? void 0 : _a.className);
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    Component,
    {
      ref: domRef,
      ...(0, import_utils3.mergeProps)(
        rowProps,
        (0, import_react_utils3.filterDOMProps)(node.props, {
          enabled: shouldFilterDOMProps
        }),
        otherProps
      ),
      className: (_b = slots.tr) == null ? void 0 : _b.call(slots, { class: trStyles }),
      children
    }
  );
});
TableHeaderRow.displayName = "NextUI.TableHeaderRow";
var table_header_row_default = TableHeaderRow;

// src/table-column-header.tsx
var import_system4 = require("@nextui-org/system");
var import_react_utils4 = require("@nextui-org/react-utils");
var import_shared_utils4 = require("@nextui-org/shared-utils");
var import_table5 = require("@react-aria/table");
var import_utils4 = require("@react-aria/utils");
var import_shared_icons = require("@nextui-org/shared-icons");
var import_focus = require("@react-aria/focus");
var import_visually_hidden = require("@react-aria/visually-hidden");
var import_interactions = require("@react-aria/interactions");
var import_jsx_runtime3 = require("react/jsx-runtime");
var TableColumnHeader = (0, import_system4.forwardRef)((props, ref) => {
  var _a, _b, _c, _d, _e;
  const { as, className, state, node, slots, classNames, ...otherProps } = props;
  const Component = as || "th";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils4.useDOMRef)(ref);
  const { columnHeaderProps } = (0, import_table5.useTableColumnHeader)({ node }, state, domRef);
  const thStyles = (0, import_shared_utils4.clsx)(classNames == null ? void 0 : classNames.th, className, (_a = node.props) == null ? void 0 : _a.className);
  const { isFocusVisible, focusProps } = (0, import_focus.useFocusRing)();
  const { isHovered, hoverProps } = (0, import_interactions.useHover)({});
  const { hideHeader, align, ...columnProps } = node.props;
  const allowsSorting = columnProps.allowsSorting;
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(
    Component,
    {
      ref: domRef,
      colSpan: node.colspan,
      "data-focus-visible": (0, import_shared_utils4.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils4.dataAttr)(isHovered),
      "data-sortable": (0, import_shared_utils4.dataAttr)(allowsSorting),
      ...(0, import_utils4.mergeProps)(
        columnHeaderProps,
        focusProps,
        (0, import_react_utils4.filterDOMProps)(columnProps, {
          enabled: shouldFilterDOMProps
        }),
        allowsSorting ? hoverProps : {},
        otherProps
      ),
      className: (_b = slots.th) == null ? void 0 : _b.call(slots, { align, class: thStyles }),
      children: [
        hideHeader ? /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_visually_hidden.VisuallyHidden, { children: node.rendered }) : node.rendered,
        allowsSorting && /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
          import_shared_icons.ChevronDownIcon,
          {
            "aria-hidden": "true",
            className: (_c = slots.sortIcon) == null ? void 0 : _c.call(slots, { class: classNames == null ? void 0 : classNames.sortIcon }),
            "data-direction": (_d = state.sortDescriptor) == null ? void 0 : _d.direction,
            "data-visible": (0, import_shared_utils4.dataAttr)(((_e = state.sortDescriptor) == null ? void 0 : _e.column) === node.key),
            strokeWidth: 3
          }
        )
      ]
    }
  );
});
TableColumnHeader.displayName = "NextUI.TableColumnHeader";
var table_column_header_default = TableColumnHeader;

// src/table-select-all-checkbox.tsx
var import_system5 = require("@nextui-org/system");
var import_react_utils5 = require("@nextui-org/react-utils");
var import_shared_utils5 = require("@nextui-org/shared-utils");
var import_table6 = require("@react-aria/table");
var import_utils5 = require("@react-aria/utils");
var import_focus2 = require("@react-aria/focus");
var import_checkbox = require("@nextui-org/checkbox");
var import_visually_hidden2 = require("@react-aria/visually-hidden");
var import_jsx_runtime4 = require("react/jsx-runtime");
var TableSelectAllCheckbox = (0, import_system5.forwardRef)((props, ref) => {
  var _a, _b;
  const {
    as,
    className,
    node,
    slots,
    state,
    selectionMode,
    color,
    checkboxesProps,
    disableAnimation,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "th";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils5.useDOMRef)(ref);
  const { columnHeaderProps } = (0, import_table6.useTableColumnHeader)({ node }, state, domRef);
  const { isFocusVisible, focusProps } = (0, import_focus2.useFocusRing)();
  const { checkboxProps } = (0, import_table6.useTableSelectAllCheckbox)(state);
  const thStyles = (0, import_shared_utils5.clsx)(classNames == null ? void 0 : classNames.th, className, (_a = node.props) == null ? void 0 : _a.className);
  const isSingleSelectionMode = selectionMode === "single";
  const { onChange, ...otherCheckboxProps } = checkboxProps;
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
    Component,
    {
      ref: domRef,
      "data-focus-visible": (0, import_shared_utils5.dataAttr)(isFocusVisible),
      ...(0, import_utils5.mergeProps)(
        columnHeaderProps,
        focusProps,
        (0, import_react_utils5.filterDOMProps)(node.props, {
          enabled: shouldFilterDOMProps
        }),
        (0, import_react_utils5.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        })
      ),
      className: (_b = slots.th) == null ? void 0 : _b.call(slots, { class: thStyles }),
      children: isSingleSelectionMode ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(import_visually_hidden2.VisuallyHidden, { children: checkboxProps["aria-label"] }) : /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
        import_checkbox.Checkbox,
        {
          color,
          disableAnimation,
          onValueChange: onChange,
          ...(0, import_utils5.mergeProps)(checkboxesProps, otherCheckboxProps)
        }
      )
    }
  );
});
TableSelectAllCheckbox.displayName = "NextUI.TableSelectAllCheckbox";
var table_select_all_checkbox_default = TableSelectAllCheckbox;

// src/table-body.tsx
var import_system9 = require("@nextui-org/system");
var import_react_utils9 = require("@nextui-org/react-utils");
var import_shared_utils9 = require("@nextui-org/shared-utils");
var import_table10 = require("@react-aria/table");
var import_react_utils10 = require("@nextui-org/react-utils");
var import_utils9 = require("@react-aria/utils");
var import_react5 = require("react");

// src/table-row.tsx
var import_system6 = require("@nextui-org/system");
var import_react_utils6 = require("@nextui-org/react-utils");
var import_shared_utils6 = require("@nextui-org/shared-utils");
var import_table7 = require("@react-aria/table");
var import_utils6 = require("@react-aria/utils");
var import_focus3 = require("@react-aria/focus");
var import_interactions2 = require("@react-aria/interactions");
var import_react3 = require("react");
var import_jsx_runtime5 = require("react/jsx-runtime");
var TableRow = (0, import_system6.forwardRef)((props, ref) => {
  var _a, _b;
  const { as, className, children, node, slots, state, isSelectable, classNames, ...otherProps } = props;
  const Component = as || ((props == null ? void 0 : props.href) ? "a" : "tr");
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils6.useDOMRef)(ref);
  const { rowProps } = (0, import_table7.useTableRow)({ node }, state, domRef);
  const trStyles = (0, import_shared_utils6.clsx)(classNames == null ? void 0 : classNames.tr, className, (_a = node.props) == null ? void 0 : _a.className);
  const { isFocusVisible, focusProps } = (0, import_focus3.useFocusRing)();
  const isDisabled = state.disabledKeys.has(node.key);
  const isSelected = state.selectionManager.isSelected(node.key);
  const { isHovered, hoverProps } = (0, import_interactions2.useHover)({ isDisabled });
  const { isFirst, isLast, isMiddle, isOdd } = (0, import_react3.useMemo)(() => {
    const isFirst2 = node.key === state.collection.getFirstKey();
    const isLast2 = node.key === state.collection.getLastKey();
    const isMiddle2 = !isFirst2 && !isLast2;
    const isOdd2 = (node == null ? void 0 : node.index) ? (node.index + 1) % 2 === 0 : false;
    return {
      isFirst: isFirst2,
      isLast: isLast2,
      isMiddle: isMiddle2,
      isOdd: isOdd2
    };
  }, [node, state.collection]);
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
    Component,
    {
      ref: domRef,
      "data-disabled": (0, import_shared_utils6.dataAttr)(isDisabled),
      "data-first": (0, import_shared_utils6.dataAttr)(isFirst),
      "data-focus-visible": (0, import_shared_utils6.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils6.dataAttr)(isHovered),
      "data-last": (0, import_shared_utils6.dataAttr)(isLast),
      "data-middle": (0, import_shared_utils6.dataAttr)(isMiddle),
      "data-odd": (0, import_shared_utils6.dataAttr)(isOdd),
      "data-selected": (0, import_shared_utils6.dataAttr)(isSelected),
      ...(0, import_utils6.mergeProps)(
        rowProps,
        focusProps,
        isSelectable ? hoverProps : {},
        (0, import_react_utils6.filterDOMProps)(node.props, {
          enabled: shouldFilterDOMProps
        }),
        otherProps
      ),
      className: (_b = slots.tr) == null ? void 0 : _b.call(slots, { class: trStyles }),
      children
    }
  );
});
TableRow.displayName = "NextUI.TableRow";
var table_row_default = TableRow;

// src/table-cell.tsx
var import_react4 = require("react");
var import_system7 = require("@nextui-org/system");
var import_react_utils7 = require("@nextui-org/react-utils");
var import_shared_utils7 = require("@nextui-org/shared-utils");
var import_table8 = require("@react-aria/table");
var import_utils7 = require("@react-aria/utils");
var import_focus4 = require("@react-aria/focus");
var import_jsx_runtime6 = require("react/jsx-runtime");
var TableCell = (0, import_system7.forwardRef)((props, ref) => {
  var _a, _b, _c;
  const { as, className, node, rowKey, slots, state, classNames, ...otherProps } = props;
  const Component = as || "td";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils7.useDOMRef)(ref);
  const { gridCellProps } = (0, import_table8.useTableCell)({ node }, state, domRef);
  const tdStyles = (0, import_shared_utils7.clsx)(classNames == null ? void 0 : classNames.td, className, (_a = node.props) == null ? void 0 : _a.className);
  const { isFocusVisible, focusProps } = (0, import_focus4.useFocusRing)();
  const isRowSelected = state.selectionManager.isSelected(rowKey);
  const cell = (0, import_react4.useMemo)(() => {
    const cellType = typeof node.rendered;
    return cellType !== "object" && cellType !== "function" ? /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("span", { children: node.rendered }) : node.rendered;
  }, [node.rendered]);
  const columnProps = ((_b = node.column) == null ? void 0 : _b.props) || {};
  return /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
    Component,
    {
      ref: domRef,
      "data-focus-visible": (0, import_shared_utils7.dataAttr)(isFocusVisible),
      "data-selected": (0, import_shared_utils7.dataAttr)(isRowSelected),
      ...(0, import_utils7.mergeProps)(
        gridCellProps,
        focusProps,
        (0, import_react_utils7.filterDOMProps)(node.props, {
          enabled: shouldFilterDOMProps
        }),
        otherProps
      ),
      className: (_c = slots.td) == null ? void 0 : _c.call(slots, { align: columnProps.align, class: tdStyles }),
      children: cell
    }
  );
});
TableCell.displayName = "NextUI.TableCell";
var table_cell_default = TableCell;

// src/table-checkbox-cell.tsx
var import_system8 = require("@nextui-org/system");
var import_react_utils8 = require("@nextui-org/react-utils");
var import_shared_utils8 = require("@nextui-org/shared-utils");
var import_table9 = require("@react-aria/table");
var import_utils8 = require("@react-aria/utils");
var import_focus5 = require("@react-aria/focus");
var import_checkbox2 = require("@nextui-org/checkbox");
var import_visually_hidden3 = require("@react-aria/visually-hidden");
var import_jsx_runtime7 = require("react/jsx-runtime");
var TableCheckboxCell = (0, import_system8.forwardRef)((props, ref) => {
  var _a, _b;
  const {
    as,
    className,
    node,
    rowKey,
    slots,
    state,
    color,
    disableAnimation,
    checkboxesProps,
    selectionMode,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "td";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils8.useDOMRef)(ref);
  const { gridCellProps } = (0, import_table9.useTableCell)({ node }, state, domRef);
  const { isFocusVisible, focusProps } = (0, import_focus5.useFocusRing)();
  const { checkboxProps } = (0, import_table9.useTableSelectionCheckbox)({ key: (node == null ? void 0 : node.parentKey) || node.key }, state);
  const tdStyles = (0, import_shared_utils8.clsx)(classNames == null ? void 0 : classNames.td, className, (_a = node.props) == null ? void 0 : _a.className);
  const isSingleSelectionMode = selectionMode === "single";
  const { onChange, ...otherCheckboxProps } = checkboxProps;
  const isRowSelected = state.selectionManager.isSelected(rowKey);
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
    Component,
    {
      ref: domRef,
      "data-focus-visible": (0, import_shared_utils8.dataAttr)(isFocusVisible),
      "data-selected": (0, import_shared_utils8.dataAttr)(isRowSelected),
      ...(0, import_utils8.mergeProps)(
        gridCellProps,
        focusProps,
        (0, import_react_utils8.filterDOMProps)(node.props, {
          enabled: shouldFilterDOMProps
        }),
        otherProps
      ),
      className: (_b = slots.td) == null ? void 0 : _b.call(slots, { class: tdStyles }),
      children: isSingleSelectionMode ? /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(import_visually_hidden3.VisuallyHidden, { children: checkboxProps["aria-label"] }) : /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
        import_checkbox2.Checkbox,
        {
          color,
          disableAnimation,
          onValueChange: onChange,
          ...(0, import_utils8.mergeProps)(checkboxesProps, otherCheckboxProps)
        }
      )
    }
  );
});
TableCheckboxCell.displayName = "NextUI.TableCheckboxCell";
var table_checkbox_cell_default = TableCheckboxCell;

// src/table-body.tsx
var import_jsx_runtime8 = require("react/jsx-runtime");
var TableBody = (0, import_system9.forwardRef)((props, ref) => {
  var _a;
  const {
    as,
    className,
    slots,
    state,
    collection,
    isSelectable,
    color,
    disableAnimation,
    checkboxesProps,
    selectionMode,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "tbody";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils9.useDOMRef)(ref);
  const { rowGroupProps } = (0, import_table10.useTableRowGroup)();
  const tbodyStyles = (0, import_shared_utils9.clsx)(classNames == null ? void 0 : classNames.tbody, className);
  const bodyProps = collection == null ? void 0 : collection.body.props;
  const isLoading = (bodyProps == null ? void 0 : bodyProps.isLoading) || (bodyProps == null ? void 0 : bodyProps.loadingState) === "loading" || (bodyProps == null ? void 0 : bodyProps.loadingState) === "loadingMore";
  const renderRows = (0, import_react5.useMemo)(() => {
    return [...collection.body.childNodes].map((row) => /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
      table_row_default,
      {
        classNames,
        isSelectable,
        node: row,
        slots,
        state,
        children: [...row.childNodes].map(
          (cell) => cell.props.isSelectionCell ? /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
            table_checkbox_cell_default,
            {
              checkboxesProps,
              classNames,
              color,
              disableAnimation,
              node: cell,
              rowKey: row.key,
              selectionMode,
              slots,
              state
            },
            cell.key
          ) : /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
            table_cell_default,
            {
              classNames,
              node: cell,
              rowKey: row.key,
              slots,
              state
            },
            cell.key
          )
        )
      },
      row.key
    ));
  }, [collection.body.childNodes, classNames, isSelectable, slots, state]);
  let emptyContent;
  let loadingContent;
  if (collection.size === 0 && bodyProps.emptyContent) {
    emptyContent = /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("tr", { role: "row", children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
      "td",
      {
        className: slots == null ? void 0 : slots.emptyWrapper({ class: classNames == null ? void 0 : classNames.emptyWrapper }),
        colSpan: collection.columnCount,
        role: "gridcell",
        children: !isLoading && bodyProps.emptyContent
      }
    ) });
  }
  if (isLoading && bodyProps.loadingContent) {
    loadingContent = /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)("tr", { role: "row", children: [
      /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
        "td",
        {
          className: slots == null ? void 0 : slots.loadingWrapper({ class: classNames == null ? void 0 : classNames.loadingWrapper }),
          colSpan: collection.columnCount,
          role: "gridcell",
          children: bodyProps.loadingContent
        }
      ),
      !emptyContent && collection.size === 0 ? /* @__PURE__ */ (0, import_jsx_runtime8.jsx)("td", { className: slots == null ? void 0 : slots.emptyWrapper({ class: classNames == null ? void 0 : classNames.emptyWrapper }) }) : null
    ] });
  }
  return /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(
    Component,
    {
      ref: domRef,
      ...(0, import_utils9.mergeProps)(
        rowGroupProps,
        (0, import_react_utils10.filterDOMProps)(bodyProps, {
          enabled: shouldFilterDOMProps
        }),
        otherProps
      ),
      className: (_a = slots.tbody) == null ? void 0 : _a.call(slots, { class: tbodyStyles }),
      "data-empty": (0, import_shared_utils9.dataAttr)(collection.size === 0),
      "data-loading": (0, import_shared_utils9.dataAttr)(isLoading),
      children: [
        renderRows,
        loadingContent,
        emptyContent
      ]
    }
  );
});
TableBody.displayName = "NextUI.TableBody";
var table_body_default = TableBody;

// src/table.tsx
var import_jsx_runtime9 = require("react/jsx-runtime");
var Table = (0, import_system10.forwardRef)((props, ref) => {
  const {
    BaseComponent,
    Component,
    collection,
    values,
    topContent,
    topContentPlacement,
    bottomContentPlacement,
    bottomContent,
    removeWrapper,
    getBaseProps,
    getWrapperProps,
    getTableProps
  } = useTable({
    ...props,
    ref
  });
  const Wrapper = (0, import_react6.useCallback)(
    ({ children }) => {
      if (removeWrapper) {
        return children;
      }
      return /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(BaseComponent, { ...getWrapperProps(), children });
    },
    [removeWrapper, getWrapperProps]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)("div", { ...getBaseProps(), children: [
    topContentPlacement === "outside" && topContent,
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(Wrapper, { children: /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(import_jsx_runtime9.Fragment, { children: [
      topContentPlacement === "inside" && topContent,
      /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(Component, { ...getTableProps(), children: [
        /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(table_row_group_default, { classNames: values.classNames, slots: values.slots, children: [
          collection.headerRows.map((headerRow) => /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
            table_header_row_default,
            {
              classNames: values.classNames,
              node: headerRow,
              slots: values.slots,
              state: values.state,
              children: [...headerRow.childNodes].map(
                (column) => {
                  var _a;
                  return ((_a = column == null ? void 0 : column.props) == null ? void 0 : _a.isSelectionCell) ? /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
                    table_select_all_checkbox_default,
                    {
                      checkboxesProps: values.checkboxesProps,
                      classNames: values.classNames,
                      color: values.color,
                      disableAnimation: values.disableAnimation,
                      node: column,
                      selectionMode: values.selectionMode,
                      slots: values.slots,
                      state: values.state
                    },
                    column == null ? void 0 : column.key
                  ) : /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
                    table_column_header_default,
                    {
                      classNames: values.classNames,
                      node: column,
                      slots: values.slots,
                      state: values.state
                    },
                    column == null ? void 0 : column.key
                  );
                }
              )
            },
            headerRow == null ? void 0 : headerRow.key
          )),
          /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_spacer.Spacer, { as: "tr", tabIndex: -1, y: 1 })
        ] }),
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
          table_body_default,
          {
            checkboxesProps: values.checkboxesProps,
            classNames: values.classNames,
            collection: values.collection,
            color: values.color,
            disableAnimation: values.disableAnimation,
            isSelectable: values.isSelectable,
            selectionMode: values.selectionMode,
            slots: values.slots,
            state: values.state
          }
        )
      ] }),
      bottomContentPlacement === "inside" && bottomContent
    ] }) }),
    bottomContentPlacement === "outside" && bottomContent
  ] });
});
Table.displayName = "NextUI.Table";
var table_default = Table;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
