"use client";
import {
  useSwitch
} from "./chunk-VOHVN7KC.mjs";

// src/switch.tsx
import { cloneElement } from "react";
import { forwardRef } from "@nextui-org/system";
import { jsx, jsxs } from "react/jsx-runtime";
var Switch = forwardRef((props, ref) => {
  const {
    Component,
    children,
    startContent,
    endContent,
    thumbIcon,
    getBaseProps,
    getInputProps,
    getWrapperProps,
    getThumbProps,
    getThumbIconProps,
    getLabelProps,
    getStartContentProps,
    getEndContentProps
  } = useSwitch({ ...props, ref });
  const clonedThumbIcon = typeof thumbIcon === "function" ? thumbIcon(getThumbIconProps({ includeStateProps: true })) : thumbIcon && cloneElement(thumbIcon, getThumbIconProps());
  const clonedStartContent = startContent && cloneElement(startContent, getStartContentProps());
  const clonedEndContent = endContent && cloneElement(endContent, getEndContentProps());
  return /* @__PURE__ */ jsxs(Component, { ...getBaseProps(), children: [
    /* @__PURE__ */ jsx("input", { ...getInputProps() }),
    /* @__PURE__ */ jsxs("span", { ...getWrapperProps(), children: [
      startContent && clonedStartContent,
      /* @__PURE__ */ jsx("span", { ...getThumbProps(), children: thumbIcon && clonedThumbIcon }),
      endContent && clonedEndContent
    ] }),
    children && /* @__PURE__ */ jsx("span", { ...getLabelProps(), children })
  ] });
});
Switch.displayName = "NextUI.Switch";
var switch_default = Switch;

export {
  switch_default
};
