"use client";
import {
  usePopover
} from "./chunk-BMSUXXDY.mjs";

// src/free-solo-popover.tsx
import * as React from "react";
import { DismissButton, Overlay } from "@react-aria/overlays";
import { forwardRef } from "@nextui-org/system";
import { LazyMotion, m } from "framer-motion";
import { mergeProps } from "@react-aria/utils";
import { getTransformOrigins } from "@nextui-org/aria-utils";
import { TRANSITION_VARIANTS } from "@nextui-org/framer-utils";
import { useDialog } from "@react-aria/dialog";
import { jsx, jsxs } from "react/jsx-runtime";
var domAnimation = () => import("@nextui-org/dom-animation").then((res) => res.default);
var FreeSoloPopoverWrapper = forwardRef(
  ({
    children,
    motionProps,
    placement,
    disableAnimation,
    style: styleProp = {},
    transformOrigin = {},
    ...otherProps
  }, ref) => {
    let style = styleProp;
    if (transformOrigin.originX !== void 0 || transformOrigin.originY !== void 0) {
      style = {
        ...style,
        transformOrigin
      };
    } else if (placement) {
      style = {
        ...style,
        ...getTransformOrigins(placement === "center" ? "top" : placement)
      };
    }
    return disableAnimation ? /* @__PURE__ */ jsx("div", { ...otherProps, ref, children }) : /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(
      m.div,
      {
        ref,
        animate: "enter",
        exit: "exit",
        initial: "initial",
        style,
        variants: TRANSITION_VARIANTS.scaleSpringOpacity,
        ...mergeProps(otherProps, motionProps),
        children
      }
    ) });
  }
);
FreeSoloPopoverWrapper.displayName = "NextUI.FreeSoloPopoverWrapper";
var FreeSoloPopover = forwardRef(
  ({ children, transformOrigin, disableDialogFocus = false, ...props }, ref) => {
    const {
      Component,
      state,
      placement,
      backdrop,
      portalContainer,
      disableAnimation,
      motionProps,
      isNonModal,
      getPopoverProps,
      getBackdropProps,
      getDialogProps,
      getContentProps
    } = usePopover({
      ...props,
      ref
    });
    const dialogRef = React.useRef(null);
    const { dialogProps: ariaDialogProps, titleProps } = useDialog({}, dialogRef);
    const dialogProps = getDialogProps({
      ...!disableDialogFocus && { ref: dialogRef },
      ...ariaDialogProps
    });
    const backdropContent = React.useMemo(() => {
      if (backdrop === "transparent") {
        return null;
      }
      if (disableAnimation) {
        return /* @__PURE__ */ jsx("div", { ...getBackdropProps() });
      }
      return /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(
        m.div,
        {
          animate: "enter",
          exit: "exit",
          initial: "exit",
          variants: TRANSITION_VARIANTS.fade,
          ...getBackdropProps()
        }
      ) });
    }, [backdrop, disableAnimation, getBackdropProps]);
    return /* @__PURE__ */ jsxs(Overlay, { portalContainer, children: [
      !isNonModal && backdropContent,
      /* @__PURE__ */ jsx(Component, { ...getPopoverProps(), children: /* @__PURE__ */ jsxs(
        FreeSoloPopoverWrapper,
        {
          disableAnimation,
          motionProps,
          placement,
          tabIndex: -1,
          transformOrigin,
          ...dialogProps,
          children: [
            !isNonModal && /* @__PURE__ */ jsx(DismissButton, { onDismiss: state.close }),
            /* @__PURE__ */ jsx("div", { ...getContentProps(), children: typeof children === "function" ? children(titleProps) : children }),
            /* @__PURE__ */ jsx(DismissButton, { onDismiss: state.close })
          ]
        }
      ) })
    ] });
  }
);
FreeSoloPopover.displayName = "NextUI.FreeSoloPopover";
var free_solo_popover_default = FreeSoloPopover;

export {
  free_solo_popover_default
};
