"use client";
import {
  useModal
} from "./chunk-S5DIVYM4.mjs";
import {
  ModalProvider
} from "./chunk-6JNB4JMH.mjs";

// src/modal.tsx
import { AnimatePresence } from "framer-motion";
import { Overlay } from "@react-aria/overlays";
import { forwardRef } from "@nextui-org/system";
import { jsx } from "react/jsx-runtime";
var Modal = forwardRef((props, ref) => {
  const { children, ...otherProps } = props;
  const context = useModal({ ...otherProps, ref });
  const overlay = /* @__PURE__ */ jsx(Overlay, { portalContainer: context.portalContainer, children });
  return /* @__PURE__ */ jsx(ModalProvider, { value: context, children: context.disableAnimation && context.isOpen ? overlay : /* @__PURE__ */ jsx(AnimatePresence, { children: context.isOpen ? overlay : null }) });
});
Modal.displayName = "NextUI.Modal";
var modal_default = Modal;

export {
  modal_default
};
