"use client";
import {
  listbox_item_default
} from "./chunk-NYZDV4AY.mjs";

// src/listbox-section.tsx
import { listboxSection } from "@nextui-org/theme";
import { useMemo } from "react";
import { forwardRef } from "@nextui-org/system";
import { mergeProps } from "@react-aria/utils";
import { clsx } from "@nextui-org/shared-utils";
import { Divider } from "@nextui-org/divider";
import { useListBoxSection } from "@react-aria/listbox";
import { jsx, jsxs } from "react/jsx-runtime";
var ListboxSection = forwardRef(
  ({
    item,
    state,
    as,
    variant,
    color,
    disableAnimation,
    className,
    classNames,
    hideSelectedIcon,
    showDivider = false,
    dividerProps = {},
    itemClasses,
    title,
    items,
    ...otherProps
  }, _) => {
    const Component = as || "li";
    const slots = useMemo(() => listboxSection(), []);
    const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
    const dividerStyles = clsx(classNames == null ? void 0 : classNames.divider, dividerProps == null ? void 0 : dividerProps.className);
    const { itemProps, headingProps, groupProps } = useListBoxSection({
      heading: item.rendered,
      "aria-label": item["aria-label"]
    });
    return /* @__PURE__ */ jsxs(
      Component,
      {
        "data-slot": "base",
        ...mergeProps(itemProps, otherProps),
        className: slots.base({ class: baseStyles }),
        children: [
          item.rendered && /* @__PURE__ */ jsx(
            "span",
            {
              ...headingProps,
              className: slots.heading({ class: classNames == null ? void 0 : classNames.heading }),
              "data-slot": "heading",
              children: item.rendered
            }
          ),
          /* @__PURE__ */ jsxs(
            "ul",
            {
              ...groupProps,
              className: slots.group({ class: classNames == null ? void 0 : classNames.group }),
              "data-has-title": !!item.rendered,
              "data-slot": "group",
              children: [
                [...item.childNodes].map((node) => {
                  const { key: nodeKey, props: nodeProps } = node;
                  let listboxItem = /* @__PURE__ */ jsx(
                    listbox_item_default,
                    {
                      classNames: itemClasses,
                      color,
                      disableAnimation,
                      hideSelectedIcon,
                      item: node,
                      state,
                      variant,
                      ...nodeProps
                    },
                    nodeKey
                  );
                  if (node.wrapper) {
                    listboxItem = node.wrapper(listboxItem);
                  }
                  return listboxItem;
                }),
                showDivider && /* @__PURE__ */ jsx(
                  Divider,
                  {
                    as: "li",
                    className: slots.divider({
                      class: dividerStyles
                    }),
                    ...dividerProps
                  }
                )
              ]
            }
          )
        ]
      },
      item.key
    );
  }
);
ListboxSection.displayName = "NextUI.ListboxSection";
var listbox_section_default = ListboxSection;

export {
  listbox_section_default
};
