"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/input-otp-segment.tsx
var input_otp_segment_exports = {};
__export(input_otp_segment_exports, {
  InputOtpSegment: () => InputOtpSegment
});
module.exports = __toCommonJS(input_otp_segment_exports);
var import_react = require("react");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_theme = require("@nextui-org/theme");

// src/input-otp-context.ts
var import_react_utils = require("@nextui-org/react-utils");
var [InputOtpProvider, useInputOtpContext] = (0, import_react_utils.createContext)({
  name: "InputOtpContext",
  errorMessage: "useInputOtpContext: `context` is undefined. Seems like you forgot to wrap all input-otp components within `<InputOtp />`"
});

// src/input-otp-segment.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var InputOtpSegment = ({
  ...props
}) => {
  var _a;
  const { classNames, slots, type } = useInputOtpContext();
  const passwordCharStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.passwordChar);
  const caretStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.caret);
  const segmentStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.segment);
  const displayValue = (0, import_react.useMemo)(() => {
    var _a2, _b;
    if (props.isActive && !props.char) {
      return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: (0, import_theme.cn)((_a2 = slots.caret) == null ? void 0 : _a2.call(slots, { class: caretStyles })) });
    }
    if (props.char) {
      return type === "password" ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: (0, import_theme.cn)((_b = slots.passwordChar) == null ? void 0 : _b.call(slots, { class: passwordCharStyles })) }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: props.char });
    }
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { children: props.placeholderChar });
  }, [props.char, props.isActive, props.placeholderChar, type]);
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    "div",
    {
      className: (0, import_theme.cn)((_a = slots.segment) == null ? void 0 : _a.call(slots, { class: segmentStyles })),
      "data-active": (0, import_shared_utils.dataAttr)(props.isActive),
      "data-focus": (0, import_shared_utils.dataAttr)(props.isFocused && props.isActive),
      "data-focus-visible": (0, import_shared_utils.dataAttr)(props.isFocusVisible && props.isActive),
      "data-has-value": (0, import_shared_utils.dataAttr)(!!props.char),
      "data-slot": "segment2",
      role: "presentation",
      children: displayValue
    }
  );
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  InputOtpSegment
});
