"use client";
import {
  useImage
} from "./chunk-7THIFN6D.mjs";

// src/image.tsx
import { cloneElement } from "react";
import { forwardRef } from "@nextui-org/system";
import { jsx, jsxs } from "react/jsx-runtime";
var Image = forwardRef((props, ref) => {
  const {
    Component,
    domRef,
    slots,
    classNames,
    isBlurred,
    isZoomed,
    fallbackSrc,
    removeWrapper,
    disableSkeleton,
    getImgProps,
    getWrapperProps,
    getBlurredImgProps
  } = useImage({
    ...props,
    ref
  });
  const img = /* @__PURE__ */ jsx(Component, { ref: domRef, ...getImgProps() });
  if (removeWrapper) {
    return img;
  }
  const zoomed = /* @__PURE__ */ jsx("div", { className: slots.zoomedWrapper({ class: classNames == null ? void 0 : classNames.zoomedWrapper }), children: img });
  if (isBlurred) {
    return /* @__PURE__ */ jsxs("div", { ...getWrapperProps(), children: [
      isZoomed ? zoomed : img,
      cloneElement(img, getBlurredImgProps())
    ] });
  }
  if (isZoomed || !disableSkeleton || fallbackSrc) {
    return /* @__PURE__ */ jsxs("div", { ...getWrapperProps(), children: [
      " ",
      isZoomed ? zoomed : img
    ] });
  }
  return img;
});
Image.displayName = "NextUI.Image";
var image_default = Image;

export {
  image_default
};
