"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/use-drawer.ts
var use_drawer_exports = {};
__export(use_drawer_exports, {
  useDrawer: () => useDrawer
});
module.exports = __toCommonJS(use_drawer_exports);
var import_theme = require("@nextui-org/theme");
var import_react_utils = require("@nextui-org/react-utils");
var import_react = require("react");
var import_framer_utils = require("@nextui-org/framer-utils");
var import_shared_utils = require("@nextui-org/shared-utils");
function useDrawer(originalProps) {
  const {
    ref,
    className,
    classNames,
    placement = "right",
    scrollBehavior = "inside",
    size = "md",
    motionProps: drawerMotionProps,
    ...otherProps
  } = originalProps;
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const motionProps = (0, import_react.useMemo)(() => {
    if (!(0, import_shared_utils.isEmpty)(drawerMotionProps))
      return drawerMotionProps;
    const key = placement === "left" || placement === "right" ? "x" : "y";
    return {
      variants: {
        enter: {
          [key]: 0,
          transition: {
            [key]: {
              duration: 0.2,
              ease: import_framer_utils.TRANSITION_EASINGS.easeOut
            }
          }
        },
        exit: {
          [key]: placement === "top" || placement === "left" ? "-100%" : "100%",
          transition: {
            [key]: {
              duration: 0.1,
              ease: import_framer_utils.TRANSITION_EASINGS.easeIn
            }
          }
        }
      }
    };
  }, [placement, drawerMotionProps]);
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.drawer)({
      size,
      placement
    }),
    [size, placement]
  );
  const getModalProps = (0, import_react.useCallback)(() => {
    return {
      classNames: {
        ...classNames,
        base: slots.base({ class: baseStyles })
      },
      motionProps,
      scrollBehavior,
      size,
      ...otherProps
    };
  }, [baseStyles, classNames, motionProps, scrollBehavior, size, otherProps]);
  return { domRef, getModalProps };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  useDrawer
});
