import * as _nextui_org_system from '@nextui-org/system';
import { PropGetter } from '@nextui-org/system';
import * as react from 'react';
import { ModalProps } from '@nextui-org/modal';
import { ReactRef } from '@nextui-org/react-utils';

interface Props extends Omit<ModalProps, "placement" | "scrollBehavior" | "children"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * The placement of the drawer.
     */
    placement?: "top" | "right" | "bottom" | "left";
    /**
     * The scroll behavior of the drawer.
     */
    scrollBehavior?: "inside" | "outside";
}
type UseDrawerProps = Props;
declare function useDrawer(originalProps: UseDrawerProps): {
    domRef: react.RefObject<HTMLElement>;
    getModalProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
};
type UseDrawerReturn = ReturnType<typeof useDrawer>;

export { UseDrawerProps, UseDrawerReturn, useDrawer };
