import { DateValue } from '@internationalized/date';
import { ReactElement } from 'react';
import { UseDatePickerProps } from './use-date-picker.js';
import '@nextui-org/date-input';
import '@react-stately/datepicker';
import '@nextui-org/button';
import '@nextui-org/calendar';
import '@nextui-org/popover';
import './use-date-picker-base.js';
import '@react-types/datepicker';
import '@nextui-org/system';
import '@react-types/shared';
import '@nextui-org/theme';
import '@react-aria/datepicker';

interface Props<T extends DateValue> extends UseDatePickerProps<T> {
    /**
     * The placement of the selector button.
     * @default "end"
     */
    selectorButtonPlacement?: "start" | "end";
}
type DatePickerProps<T extends DateValue = DateValue> = Props<T>;
declare const DatePicker: <T extends DateValue>(props: DatePickerProps<T>) => ReactElement;

export { DatePickerProps, Props, DatePicker as default };
