import * as _react_types_shared from '@react-types/shared';
import * as _react_types_calendar from '@react-types/calendar';
import { CalendarPropsBase } from '@react-types/calendar';
import * as react from 'react';
import { RefObject, ReactNode } from 'react';
import * as _internationalized_date from '@internationalized/date';
import { CalendarDate, Calendar } from '@internationalized/date';
import * as tailwind_variants from 'tailwind-variants';
import * as _nextui_org_system from '@nextui-org/system';
import { SupportedCalendars, PropGetter, HTMLNextUIProps } from '@nextui-org/system';
import { CalendarVariantProps, CalendarReturnType, SlotsToClasses, CalendarSlots } from '@nextui-org/theme';
import { AriaCalendarGridProps } from '@react-aria/calendar';
import { AriaButtonProps } from '@react-types/button';
import { ButtonProps } from '@nextui-org/button';
import { CalendarState, RangeCalendarState } from '@react-stately/calendar';
import { ReactRef } from '@nextui-org/react-utils';

type NextUIBaseProps = Omit<HTMLNextUIProps<"div">, keyof CalendarPropsBase | "onChange">;
interface Props extends NextUIBaseProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * Custom content to be included in the top of the calendar.
     */
    topContent?: ReactNode;
    /**
     * Custom content to be included in the bottom of the calendar.
     */
    bottomContent?: ReactNode;
    /**
     * The number of months to display at once. Up to 3 months are supported.
     * Passing a number greater than 1 will disable the `showMonthAndYearPickers` prop.
     *
     * @default 1
     */
    visibleMonths?: number;
    /**
     * The width to be applied to the calendar component. This value is multiplied by the number
     * of visible months to determine the total width of the calendar.
     *
     * @default 256
     */
    calendarWidth?: number | string;
    /**
     * Props for the navigation button, prev button and next button.
     */
    navButtonProps?: ButtonProps;
    /**
     * Props for the previous button.
     */
    prevButtonProps?: ButtonProps;
    /**
     * Props for the next button.
     */
    nextButtonProps?: ButtonProps;
    /**
     * Whether to show the description or error message.
     * @default true
     */
    showHelper?: boolean;
    /**
     * Whether the calendar header is expanded. This is only available if the `showMonthAndYearPickers` prop is set to `true`.
     * @default false
     */
    isHeaderExpanded?: boolean;
    /**
     * Whether the calendar header should be expanded by default.This is only available if the `showMonthAndYearPickers` prop is set to `true`.
     * @default false
     */
    isHeaderDefaultExpanded?: boolean;
    /**
     * The event handler for the calendar header expanded state. This is only available if the `showMonthAndYearPickers` prop is set to `true`.
     * @param isExpanded boolean
     * @returns void
     */
    onHeaderExpandedChange?: (isExpanded: boolean) => void;
    /**
     * This function helps to reduce the bundle size by providing a custom calendar system.
     *
     * In the example above, the createCalendar function from the `@internationalized/date` package
     * is passed to the useCalendarState hook. This function receives a calendar identifier string,
     * and provides Calendar instances to React Stately, which are used to implement date manipulation.
     *
     * By default, this includes all calendar systems supported by @internationalized/date. However,
     * if your application supports a more limited set of regions, or you know you will only be picking dates
     * in a certain calendar system, you can reduce your bundle size by providing your own implementation
     * of `createCalendar` that includes a subset of these Calendar implementations.
     *
     * For example, if your application only supports Gregorian dates, you could implement a `createCalendar`
     * function like this:
     *
     * @example
     *
     * import {GregorianCalendar} from '@internationalized/date';
     *
     * function createCalendar(identifier) {
     *  switch (identifier) {
     *    case 'gregory':
     *      return new GregorianCalendar();
     *    default:
     *      throw new Error(`Unsupported calendar ${identifier}`);
     *  }
     * }
     *
     * This way, only GregorianCalendar is imported, and the other calendar implementations can be tree-shaken.
     *
     * You can also use the NextUIProvider to provide the createCalendar function to all nested components.
     *
     * @default all calendars
     */
    createCalendar?: (calendar: SupportedCalendars) => Calendar | null;
    /**
     * The style of weekday names to display in the calendar grid header,
     * e.g. single letter, abbreviation, or full day name.
     * @default "narrow"
     */
    weekdayStyle?: AriaCalendarGridProps["weekdayStyle"];
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     *
     * Component: Calendar, RangeCalendar
     *
     * <Component classNames={{
     *    base:"base-classes",
     *    nextButton:"next-button-classes",
     *    prevButton:"prev-button-classes",
     *    header:"header-classes",
     *    title:"title-classes",
     *    content:"content-classes",
     *    gridWrapper:"grid-wrapper-classes",
     *    grid:"grid-classes",
     *    gridHeader:"grid-header-classes",
     *    gridHeaderRow:"grid-header-row-classes",
     *    gridHeaderCell:"grid-header-cell-classes",
     *    gridBody:"grid-body-classes",
     *    gridBodyRow:"grid-row-classes",
     *    cell:"grid-cell-classes",
     *    cellButton:"grid-cell-button-classes",
     *    pickerWrapper:"picker-wrapper-classes",
     *    pickerMonthList:"picker-month-list-classes",
     *    pickerYearList:"picker-year-list-classes",
     *    pickerHighlight:"picker-highlight-classes",
     *    pickerItem:"picker-item-classes",
     *    helperWrapper:"helper-wrapper-classes",
     *    errorMessage:"error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<CalendarSlots>;
}
type UseCalendarBasePropsComplete = Props & CalendarVariantProps & CalendarPropsBase;
type UseCalendarBaseProps = Omit<UseCalendarBasePropsComplete, "isRange"> & {
    /**
     * Props for the button picker, which is used to select the month, year and expand the header.
     */
    buttonPickerProps?: ButtonProps;
};
type ContextType<T extends CalendarState | RangeCalendarState> = {
    state: T;
    visibleMonths: number;
    headerRef?: RefObject<any>;
    slots?: CalendarReturnType;
    weekdayStyle?: AriaCalendarGridProps["weekdayStyle"];
    isHeaderExpanded?: boolean;
    showMonthAndYearPickers?: boolean;
    setIsHeaderExpanded?: (isExpanded: boolean) => void;
    classNames?: SlotsToClasses<CalendarSlots>;
    disableAnimation?: boolean;
};
declare function useCalendarBase(originalProps: UseCalendarBasePropsComplete): {
    Component: _nextui_org_system.As<any>;
    children: ReactNode;
    domRef: RefObject<HTMLDivElement>;
    slots: {
        base: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
    } & {};
    locale: string;
    minValue: CalendarDate | _internationalized_date.CalendarDateTime | _internationalized_date.ZonedDateTime | null;
    maxValue: CalendarDate | _internationalized_date.CalendarDateTime | _internationalized_date.ZonedDateTime | null;
    baseProps: {
        "data-slot": string;
        "data-has-multiple-months": boolean | "true" | "false";
        style: react.CSSProperties;
    };
    showHelper: boolean;
    weekdayStyle: "narrow" | "short" | "long";
    visibleMonths: number;
    visibleDuration: {
        months: number;
    };
    shouldFilterDOMProps: boolean;
    isHeaderExpanded: boolean | undefined;
    showMonthAndYearPickers: boolean | undefined;
    disableAnimation: boolean;
    createCalendar: ((calendar: SupportedCalendars) => Calendar | null) | null;
    getPrevButtonProps: (props?: {}) => AriaButtonProps<"button">;
    getNextButtonProps: (props?: {}) => AriaButtonProps<"button">;
    getErrorMessageProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    setIsHeaderExpanded: (value: boolean | undefined, ...args: any[]) => void;
    topContent: ReactNode;
    bottomContent: ReactNode;
    errorMessage: ReactNode;
    classNames: SlotsToClasses<"base" | "header" | "title" | "content" | "errorMessage" | "gridWrapper" | "grid" | "gridHeader" | "gridHeaderRow" | "gridHeaderCell" | "gridBody" | "gridBodyRow" | "cell" | "pickerWrapper" | "pickerMonthList" | "pickerYearList" | "pickerHighlight" | "helperWrapper" | "prevButton" | "nextButton" | "headerWrapper" | "cellButton" | "pickerItem"> | undefined;
    otherProps: {
        style?: react.CSSProperties | undefined;
        title?: string | undefined;
        key?: react.Key | null | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        accessKey?: string | undefined;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        contextMenu?: string | undefined;
        dir?: string | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined;
        id?: string | undefined;
        lang?: string | undefined;
        nonce?: string | undefined;
        placeholder?: string | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        tabIndex?: number | undefined;
        translate?: "yes" | "no" | undefined;
        radioGroup?: string | undefined;
        role?: react.AriaRole | undefined;
        about?: string | undefined;
        content?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        prefix?: string | undefined;
        property?: string | undefined;
        rel?: string | undefined;
        resource?: string | undefined;
        rev?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        inputMode?: "text" | "search" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
        is?: string | undefined;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "list" | "none" | "inline" | "both" | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-controls'?: string | undefined;
        'aria-current'?: boolean | "time" | "true" | "false" | "page" | "step" | "location" | "date" | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "link" | "none" | "copy" | "execute" | "move" | "popup" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "true" | "false" | "listbox" | "tree" | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-label'?: string | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCopyCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCut?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCutCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPaste?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPasteCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCompositionEnd?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionEndCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStart?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStartCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdate?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onFocus?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onFocusCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlur?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlurCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onChangeCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onReset?: react.FormEventHandler<HTMLDivElement> | undefined;
        onResetCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmit?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmitCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalid?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalidCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onLoad?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onError?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onErrorCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onKeyDown?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyDownCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPress?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPressCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUp?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUpCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onAbort?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAbortCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThrough?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThroughCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptied?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptiedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncrypted?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncryptedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEnded?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEndedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedData?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedDataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadata?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStart?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStartCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPause?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPauseCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlaying?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgress?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgressCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResize?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResizeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeked?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeking?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalled?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalledCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspend?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspendCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdate?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdateCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaiting?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaitingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAuxClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onAuxClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenu?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenuCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDrag?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnd?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEndCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnter?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnterCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExit?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExitCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeave?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeaveCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOver?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOverCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStart?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStartCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDrop?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDropCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onMouseDown?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseDownCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseEnter?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseLeave?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMove?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMoveCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOut?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOutCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOver?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOverCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUp?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUpCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onSelect?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSelectCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTouchCancel?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchCancelCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEnd?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEndCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMove?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMoveCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStart?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStartCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onPointerDown?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerDownCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMove?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMoveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUp?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUpCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancel?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancelCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnter?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnterCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeave?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeaveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOver?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOverCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOut?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOutCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onScroll?: react.UIEventHandler<HTMLDivElement> | undefined;
        onScrollCapture?: react.UIEventHandler<HTMLDivElement> | undefined;
        onWheel?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onWheelCapture?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onAnimationStart?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationStartCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEnd?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEndCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIteration?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIterationCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onTransitionEnd?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEndCapture?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
        isRange?: boolean | undefined;
        hideDisabledDates?: boolean | undefined;
        isHeaderWrapperExpanded?: boolean | undefined;
        showMonthAndYearPickers?: boolean | undefined;
        showShadow?: boolean | undefined;
        disableAnimation?: boolean | undefined;
        isDateUnavailable?: ((date: _react_types_calendar.DateValue) => boolean) | undefined;
        isDisabled?: boolean | undefined;
        isReadOnly?: boolean | undefined;
        autoFocus?: boolean | undefined;
        focusedValue?: _react_types_calendar.DateValue | null | undefined;
        defaultFocusedValue?: _react_types_calendar.DateValue | null | undefined;
        onFocusChange?: ((date: CalendarDate) => void) | undefined;
        validationState?: _react_types_shared.ValidationState | undefined;
        isInvalid?: boolean | undefined;
        pageBehavior?: _react_types_calendar.PageBehavior | undefined;
    } | {
        style?: react.CSSProperties | undefined;
        title?: string | undefined;
        key?: react.Key | null | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        accessKey?: string | undefined;
        autoFocus?: boolean | undefined;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        contextMenu?: string | undefined;
        dir?: string | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined;
        id?: string | undefined;
        lang?: string | undefined;
        nonce?: string | undefined;
        placeholder?: string | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        tabIndex?: number | undefined;
        translate?: "yes" | "no" | undefined;
        radioGroup?: string | undefined;
        role?: react.AriaRole | undefined;
        about?: string | undefined;
        content?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        prefix?: string | undefined;
        property?: string | undefined;
        rel?: string | undefined;
        resource?: string | undefined;
        rev?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "on" | "off" | undefined;
        inputMode?: "text" | "search" | "none" | "tel" | "url" | "email" | "numeric" | "decimal" | undefined;
        is?: string | undefined;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "list" | "none" | "inline" | "both" | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-controls'?: string | undefined;
        'aria-current'?: boolean | "time" | "true" | "false" | "page" | "step" | "location" | "date" | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "link" | "none" | "copy" | "execute" | "move" | "popup" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "dialog" | "menu" | "grid" | "true" | "false" | "listbox" | "tree" | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-label'?: string | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCopyCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCut?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCutCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPaste?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onPasteCapture?: react.ClipboardEventHandler<HTMLDivElement> | undefined;
        onCompositionEnd?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionEndCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStart?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionStartCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdate?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onCompositionUpdateCapture?: react.CompositionEventHandler<HTMLDivElement> | undefined;
        onFocus?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onFocusCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlur?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onBlurCapture?: react.FocusEventHandler<HTMLDivElement> | undefined;
        onChangeCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onBeforeInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInput?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInputCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onReset?: react.FormEventHandler<HTMLDivElement> | undefined;
        onResetCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmit?: react.FormEventHandler<HTMLDivElement> | undefined;
        onSubmitCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalid?: react.FormEventHandler<HTMLDivElement> | undefined;
        onInvalidCapture?: react.FormEventHandler<HTMLDivElement> | undefined;
        onLoad?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onError?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onErrorCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onKeyDown?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyDownCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPress?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyPressCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUp?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onKeyUpCapture?: react.KeyboardEventHandler<HTMLDivElement> | undefined;
        onAbort?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAbortCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThrough?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onCanPlayThroughCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onDurationChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptied?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEmptiedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncrypted?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEncryptedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEnded?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onEndedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedData?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedDataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadata?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadedMetadataCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStart?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onLoadStartCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPause?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPauseCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlay?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlaying?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onPlayingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgress?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onProgressCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onRateChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResize?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onResizeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeked?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekedCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeeking?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSeekingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalled?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onStalledCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspend?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSuspendCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdate?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTimeUpdateCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChange?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onVolumeChangeCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaiting?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onWaitingCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onAuxClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onAuxClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenu?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onContextMenuCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClick?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDoubleClickCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onDrag?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnd?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEndCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnter?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragEnterCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExit?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragExitCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeave?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragLeaveCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOver?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragOverCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStart?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDragStartCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDrop?: react.DragEventHandler<HTMLDivElement> | undefined;
        onDropCapture?: react.DragEventHandler<HTMLDivElement> | undefined;
        onMouseDown?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseDownCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseEnter?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseLeave?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMove?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseMoveCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOut?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOutCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOver?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseOverCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUp?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onMouseUpCapture?: react.MouseEventHandler<HTMLDivElement> | undefined;
        onSelect?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onSelectCapture?: react.ReactEventHandler<HTMLDivElement> | undefined;
        onTouchCancel?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchCancelCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEnd?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchEndCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMove?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchMoveCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStart?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onTouchStartCapture?: react.TouchEventHandler<HTMLDivElement> | undefined;
        onPointerDown?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerDownCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMove?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerMoveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUp?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerUpCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancel?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerCancelCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnter?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerEnterCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeave?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerLeaveCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOver?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOverCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOut?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onPointerOutCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onGotPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onLostPointerCaptureCapture?: react.PointerEventHandler<HTMLDivElement> | undefined;
        onScroll?: react.UIEventHandler<HTMLDivElement> | undefined;
        onScrollCapture?: react.UIEventHandler<HTMLDivElement> | undefined;
        onWheel?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onWheelCapture?: react.WheelEventHandler<HTMLDivElement> | undefined;
        onAnimationStart?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationStartCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEnd?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationEndCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIteration?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onAnimationIterationCapture?: react.AnimationEventHandler<HTMLDivElement> | undefined;
        onTransitionEnd?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        onTransitionEndCapture?: react.TransitionEventHandler<HTMLDivElement> | undefined;
        isDisabled?: boolean | undefined;
        onFocusChange?: ((date: CalendarDate) => void) | undefined;
        isInvalid?: boolean | undefined;
        isReadOnly?: boolean | undefined;
        isDateUnavailable?: ((date: _react_types_calendar.DateValue) => boolean) | undefined;
        focusedValue?: _react_types_calendar.DateValue | null | undefined;
        defaultFocusedValue?: _react_types_calendar.DateValue | null | undefined;
        validationState?: _react_types_shared.ValidationState | undefined;
        pageBehavior?: _react_types_calendar.PageBehavior | undefined;
    };
};
type UseCalendarBaseReturn = ReturnType<typeof useCalendarBase>;

export { ContextType, UseCalendarBaseProps, UseCalendarBasePropsComplete, UseCalendarBaseReturn, useCalendarBase };
