"use client";
import {
  useCalendarBase
} from "./chunk-TQRUXHY6.mjs";

// src/use-range-calendar.ts
import { useMemo, useRef } from "react";
import { filterDOMProps } from "@nextui-org/react-utils";
import { useRangeCalendar as useAriaRangeCalendar } from "@react-aria/calendar";
import { useRangeCalendarState } from "@react-stately/calendar";
import { createCalendar } from "@internationalized/date";
import { clsx } from "@nextui-org/shared-utils";
import { chain } from "@react-aria/utils";
function useRangeCalendar({
  buttonPickerProps: buttonPickerPropsProp,
  className,
  ...originalProps
}) {
  const {
    Component,
    slots,
    children,
    domRef,
    locale,
    showHelper,
    minValue,
    maxValue,
    weekdayStyle,
    visibleDuration,
    shouldFilterDOMProps,
    isHeaderExpanded,
    visibleMonths,
    disableAnimation,
    createCalendar: createCalendarProp,
    showMonthAndYearPickers,
    baseProps,
    getPrevButtonProps,
    getNextButtonProps,
    getErrorMessageProps,
    setIsHeaderExpanded,
    topContent,
    bottomContent,
    errorMessage,
    classNames,
    otherProps
  } = useCalendarBase({ ...originalProps, isRange: true });
  const headerRef = useRef(null);
  const state = useRangeCalendarState({
    ...originalProps,
    locale,
    minValue,
    maxValue,
    visibleDuration,
    createCalendar: !createCalendarProp || typeof createCalendarProp !== "function" ? createCalendar : createCalendarProp
  });
  const { title, calendarProps, prevButtonProps, nextButtonProps, errorMessageProps } = useAriaRangeCalendar(originalProps, state, domRef);
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  const buttonPickerProps = {
    ...buttonPickerPropsProp,
    onPress: chain(buttonPickerPropsProp == null ? void 0 : buttonPickerPropsProp.onPress, () => setIsHeaderExpanded(!isHeaderExpanded))
  };
  const getBaseCalendarProps = (props = {}) => {
    return {
      ...baseProps,
      Component,
      showHelper,
      topContent,
      bottomContent,
      buttonPickerProps,
      calendarRef: domRef,
      calendarProps,
      prevButtonProps: getPrevButtonProps(prevButtonProps),
      nextButtonProps: getNextButtonProps(nextButtonProps),
      errorMessageProps: getErrorMessageProps(errorMessageProps),
      className: slots.base({ class: baseStyles }),
      errorMessage,
      ...filterDOMProps(otherProps, {
        enabled: shouldFilterDOMProps
      }),
      ...props
    };
  };
  const context = useMemo(
    () => ({
      state,
      slots,
      headerRef,
      weekdayStyle,
      isHeaderExpanded,
      setIsHeaderExpanded,
      visibleMonths,
      showMonthAndYearPickers,
      classNames,
      disableAnimation
    }),
    [
      state,
      slots,
      classNames,
      weekdayStyle,
      isHeaderExpanded,
      setIsHeaderExpanded,
      visibleMonths,
      disableAnimation,
      showMonthAndYearPickers
    ]
  );
  return {
    Component,
    children,
    domRef,
    context,
    state,
    slots,
    title,
    classNames,
    getBaseCalendarProps
  };
}

export {
  useRangeCalendar
};
