import * as react from 'react';
import { ContextType } from './use-calendar-base.js';
import { CalendarState, RangeCalendarState } from '@react-stately/calendar';
import '@react-types/shared';
import '@react-types/calendar';
import '@internationalized/date';
import 'tailwind-variants';
import '@nextui-org/system';
import '@nextui-org/theme';
import '@react-aria/calendar';
import '@react-types/button';
import '@nextui-org/button';
import '@nextui-org/react-utils';

declare const CalendarProvider: react.Provider<ContextType<CalendarState | RangeCalendarState>>;
declare const useCalendarContext: () => ContextType<CalendarState | RangeCalendarState>;

export { CalendarProvider, useCalendarContext };
