"use client";
import {
  AvatarIcon
} from "./chunk-25E6VDTZ.mjs";
import {
  useAvatar
} from "./chunk-GVOGAY7K.mjs";

// src/avatar.tsx
import { useMemo } from "react";
import { forwardRef } from "@nextui-org/system";
import { jsx, jsxs } from "react/jsx-runtime";
var Avatar = forwardRef((props, ref) => {
  const {
    Component,
    ImgComponent,
    src,
    icon = /* @__PURE__ */ jsx(AvatarIcon, {}),
    alt,
    classNames,
    slots,
    name,
    showFallback,
    fallback: fallbackComponent,
    getInitials,
    getAvatarProps,
    getImageProps
  } = useAvatar({
    ...props,
    ref
  });
  const fallback = useMemo(() => {
    if (!showFallback && src)
      return null;
    if (fallbackComponent) {
      return /* @__PURE__ */ jsx("div", { "aria-label": alt, className: slots.fallback({ class: classNames == null ? void 0 : classNames.fallback }), role: "img", children: fallbackComponent });
    }
    return name ? /* @__PURE__ */ jsx("span", { "aria-label": alt, className: slots.name({ class: classNames == null ? void 0 : classNames.name }), role: "img", children: getInitials(name) }) : /* @__PURE__ */ jsx("span", { "aria-label": alt, className: slots.icon({ class: classNames == null ? void 0 : classNames.icon }), role: "img", children: icon });
  }, [showFallback, src, fallbackComponent, name, classNames]);
  return /* @__PURE__ */ jsxs(Component, { ...getAvatarProps(), children: [
    src && /* @__PURE__ */ jsx(ImgComponent, { ...getImageProps(), alt }),
    fallback
  ] });
});
Avatar.displayName = "NextUI.Avatar";
var avatar_default = Avatar;

export {
  avatar_default
};
