"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Alert: () => alert_default,
  useAlert: () => useAlert
});
module.exports = __toCommonJS(src_exports);

// src/alert.tsx
var import_system2 = require("@nextui-org/system");
var import_shared_icons = require("@nextui-org/shared-icons");
var import_shared_utils2 = require("@nextui-org/shared-utils");
var import_button = require("@nextui-org/button");
var import_react2 = require("react");

// src/use-alert.ts
var import_system = require("@nextui-org/system");
var import_react_utils = require("@nextui-org/react-utils");
var import_react = require("react");
var import_utils = require("@react-aria/utils");
var import_theme = require("@nextui-org/theme");
var import_utils2 = require("@react-stately/utils");
var import_shared_utils = require("@nextui-org/shared-utils");
function useAlert(originalProps) {
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.alert.variantKeys);
  const {
    as,
    title,
    children,
    description,
    onClose,
    isClosable,
    ref,
    icon,
    startContent,
    endContent,
    isVisible: isVisibleProp,
    isDefaultVisible,
    onVisibleChange,
    closeButtonProps = {
      size: "sm"
    },
    classNames,
    ...otherProps
  } = props;
  const [isVisible, setIsVisible] = (0, import_utils2.useControlledState)(
    isVisibleProp,
    isDefaultVisible != null ? isDefaultVisible : true,
    onVisibleChange
  );
  const Component = as || "div";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const handleClose = (0, import_react.useCallback)(() => {
    setIsVisible(false);
    onClose == null ? void 0 : onClose();
  }, [setIsVisible, onClose]);
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.alert)({ hasContent: !(0, import_shared_utils.isEmpty)(description) || !(0, import_shared_utils.isEmpty)(children), ...variantProps }),
    [description, (0, import_shared_utils.objectToDeps)(variantProps)]
  );
  const getBaseProps = (0, import_react.useCallback)(() => {
    return {
      "data-visible": (0, import_shared_utils.dataAttr)(isVisible),
      "data-closeable": (0, import_shared_utils.dataAttr)(isClosable),
      "data-has-title": (0, import_shared_utils.dataAttr)(!(0, import_shared_utils.isEmpty)(title)),
      "data-has-description": (0, import_shared_utils.dataAttr)(!(0, import_shared_utils.isEmpty)(description)),
      ...(0, import_utils.mergeProps)(
        (0, import_react_utils.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        (0, import_react_utils.filterDOMProps)(props)
      ),
      className: slots.base({ class: classNames == null ? void 0 : classNames.base })
    };
  }, [slots, classNames == null ? void 0 : classNames.base]);
  const getMainWrapperProps = (0, import_react.useCallback)(() => {
    return {
      className: slots.mainWrapper({ class: classNames == null ? void 0 : classNames.mainWrapper })
    };
  }, [slots, classNames == null ? void 0 : classNames.mainWrapper]);
  const getDescriptionProps = (0, import_react.useCallback)(() => {
    return {
      className: slots.description({ class: classNames == null ? void 0 : classNames.description })
    };
  }, [slots, classNames == null ? void 0 : classNames.description]);
  const getTitleProps = (0, import_react.useCallback)(() => {
    return {
      className: slots.title({ class: classNames == null ? void 0 : classNames.title })
    };
  }, [slots, classNames == null ? void 0 : classNames.title]);
  const getCloseButtonProps = (0, import_react.useCallback)(
    () => ({
      ...closeButtonProps,
      className: slots.closeButton({ class: classNames == null ? void 0 : classNames.closeButton })
    }),
    [slots, classNames == null ? void 0 : classNames.closeButton]
  );
  const getAlertIconProps = (0, import_react.useCallback)(
    () => ({
      className: slots.alertIcon({ class: classNames == null ? void 0 : classNames.alertIcon })
    }),
    [slots, classNames == null ? void 0 : classNames.alertIcon]
  );
  const getIconWrapperProps = (0, import_react.useCallback)(
    () => ({
      className: slots.iconWrapper({ class: classNames == null ? void 0 : classNames.iconWrapper })
    }),
    [slots, classNames == null ? void 0 : classNames.iconWrapper]
  );
  return {
    title,
    icon,
    children,
    description,
    isClosable,
    domRef,
    endContent,
    startContent,
    getBaseProps,
    getMainWrapperProps,
    getDescriptionProps,
    getTitleProps,
    color: variantProps["color"],
    getCloseButtonProps,
    handleClose,
    isVisible,
    onClose,
    getAlertIconProps,
    getIconWrapperProps
  };
}

// src/alert.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var iconMap = {
  primary: import_shared_icons.InfoCircleIcon,
  secondary: import_shared_icons.InfoCircleIcon,
  success: import_shared_icons.SuccessIcon,
  warning: import_shared_icons.WarningIcon,
  danger: import_shared_icons.DangerIcon
};
var Alert = (0, import_system2.forwardRef)((props, ref) => {
  const {
    title,
    icon,
    children,
    description,
    endContent,
    startContent,
    isClosable,
    domRef,
    handleClose,
    getBaseProps,
    getMainWrapperProps,
    getDescriptionProps,
    getTitleProps,
    getCloseButtonProps,
    color,
    isVisible,
    onClose,
    getAlertIconProps,
    getIconWrapperProps
  } = useAlert({ ...props, ref });
  if (!isVisible)
    return null;
  const customIcon = icon && (0, import_react2.isValidElement)(icon) ? (0, import_react2.cloneElement)(icon, getAlertIconProps()) : null;
  const IconComponent = iconMap[color] || iconMap.primary;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { ref: domRef, role: "alert", ...getBaseProps(), children: [
    startContent,
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ...getIconWrapperProps(), children: customIcon || /* @__PURE__ */ (0, import_jsx_runtime.jsx)(IconComponent, { ...getAlertIconProps() }) }),
    /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { ...getMainWrapperProps(), children: [
      title && /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ...getTitleProps(), children: title }),
      !(0, import_shared_utils2.isEmpty)(description) && /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ...getDescriptionProps(), children: description }),
      children
    ] }),
    endContent,
    (isClosable || onClose) && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_button.Button,
      {
        isIconOnly: true,
        "aria-label": "Close",
        radius: "full",
        variant: "light",
        onPress: handleClose,
        ...getCloseButtonProps(),
        children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_shared_icons.CloseIcon, { height: 20, width: 20 })
      }
    )
  ] });
});
Alert.displayName = "NextUI.Alert";
var alert_default = Alert;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Alert,
  useAlert
});
