import { Theme, SxProps } from './types';
/**
 * internal utility
 *
 * Why? to read `sx` values and attach component's CSS variables
 *      e.g. <Card sx={{ borderRadius: 0 }} /> should attach
 *          `--Card-radius: 0px` so that developers don't have to remember
 *
 * Why not reuse `styleFunctionSx`?
 *     `styleFunctionSx` is more expensive as it iterates over all the keys
 */
export declare const resolveSxValue: <K extends string>({ theme, ownerState }: {
    theme: Theme;
    ownerState: {
        sx?: SxProps;
    };
}, keys: K[]) => Record<K, undefined | number | string>;
