'use client';

import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
const _excluded = ["accordionId", "component", "color", "children", "defaultExpanded", "disabled", "expanded", "onChange", "variant", "slots", "slotProps"];
import * as React from 'react';
import PropTypes from 'prop-types';
import { unstable_composeClasses as composeClasses } from '@mui/base';
import { unstable_capitalize as capitalize, unstable_useControlled as useControlled, unstable_useId as useId } from '@mui/utils';
import { useThemeProps } from '../styles';
import styled from '../styles/styled';
import { getAccordionUtilityClass } from './accordionClasses';
import useSlot from '../utils/useSlot';
import AccordionContext from './AccordionContext';
import { StyledListItem } from '../ListItem/ListItem';
import accordionDetailsClasses from '../AccordionDetails/accordionDetailsClasses';
import { jsx as _jsx } from "react/jsx-runtime";
const useUtilityClasses = ownerState => {
  const {
    variant,
    color,
    expanded,
    disabled
  } = ownerState;
  const slots = {
    root: ['root', expanded && 'expanded', disabled && 'disabled', color && `color${capitalize(color)}`, variant && `variant${capitalize(variant)}`]
  };
  return composeClasses(slots, getAccordionUtilityClass, {});
};
const AccordionRoot = styled(StyledListItem, {
  name: 'JoyAccordion',
  slot: 'Root',
  overridesResolver: (props, styles) => styles.root
})({
  borderBottom: 'var(--Accordion-borderBottom)',
  '&[data-first-child]': {
    '--ListItem-radius': 'var(--unstable_List-childRadius) var(--unstable_List-childRadius) 0 0'
  },
  '&[data-last-child]': {
    '--ListItem-radius': '0 0 var(--unstable_List-childRadius) var(--unstable_List-childRadius)',
    '& [aria-expanded="true"]': {
      '--ListItem-radius': '0'
    },
    [`& .${accordionDetailsClasses.root}`]: {
      '--AccordionDetails-radius': '0 0 var(--unstable_List-childRadius) var(--unstable_List-childRadius)'
    }
  },
  '&:not([data-first-child]):not([data-last-child])': {
    '--ListItem-radius': '0'
  }
});
/**
 *
 * Demos:
 *
 * - [Accordion](https://mui.com/joy-ui/react-accordion/)
 *
 * API:
 *
 * - [Accordion API](https://mui.com/joy-ui/api/accordion/)
 */
const Accordion = /*#__PURE__*/React.forwardRef(function Accordion(inProps, ref) {
  const props = useThemeProps({
    props: inProps,
    name: 'JoyAccordion'
  });
  const {
      accordionId: idOverride,
      component = 'div',
      color = 'neutral',
      children,
      defaultExpanded = false,
      disabled = false,
      expanded: expandedProp,
      onChange,
      variant = 'plain',
      slots = {},
      slotProps = {}
    } = props,
    other = _objectWithoutPropertiesLoose(props, _excluded);
  const accordionId = useId(idOverride);
  const [expanded, setExpandedState] = useControlled({
    controlled: expandedProp,
    default: defaultExpanded,
    name: 'Accordion',
    state: 'expanded'
  });
  const handleChange = React.useCallback(event => {
    setExpandedState(!expanded);
    if (onChange) {
      onChange(event, !expanded);
    }
  }, [expanded, onChange, setExpandedState]);
  const contextValue = React.useMemo(() => ({
    accordionId,
    expanded,
    disabled,
    toggle: handleChange
  }), [accordionId, expanded, disabled, handleChange]);
  const externalForwardedProps = _extends({}, other, {
    component,
    slots,
    slotProps
  });
  const ownerState = _extends({}, props, {
    component,
    color,
    variant,
    expanded,
    disabled,
    nested: true // for the ListItem styles
  });
  const classes = useUtilityClasses(ownerState);
  const [SlotRoot, rootProps] = useSlot('root', {
    ref,
    className: classes.root,
    elementType: AccordionRoot,
    externalForwardedProps,
    ownerState
  });
  return /*#__PURE__*/_jsx(AccordionContext.Provider, {
    value: contextValue,
    children: /*#__PURE__*/_jsx(SlotRoot, _extends({}, rootProps, {
      children: React.Children.map(children, (child, index) => /*#__PURE__*/React.isValidElement(child) && index === 0 ? /*#__PURE__*/React.cloneElement(child, {
        // @ts-ignore: to let ListItem knows when to apply margin(Inline|Block)Start
        'data-first-child': ''
      }) : child)
    }))
  });
});
process.env.NODE_ENV !== "production" ? Accordion.propTypes /* remove-proptypes */ = {
  // ┌────────────────────────────── Warning ──────────────────────────────┐
  // │ These PropTypes are generated from the TypeScript type definitions. │
  // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
  // └─────────────────────────────────────────────────────────────────────┘
  /**
   * The id to be used in the AccordionDetails which is controlled by the AccordionSummary.
   * If not provided, the id is autogenerated.
   */
  accordionId: PropTypes.string,
  /**
   * Used to render icon or text elements inside the Accordion if `src` is not set.
   * This can be an element, or just a string.
   */
  children: PropTypes.node,
  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   * @default 'neutral'
   */
  color: PropTypes.oneOf(['danger', 'neutral', 'primary', 'success', 'warning']),
  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: PropTypes.elementType,
  /**
   * If `true`, expands the accordion by default.
   * @default false
   */
  defaultExpanded: PropTypes.bool,
  /**
   * If `true`, the component is disabled.
   * @default false
   */
  disabled: PropTypes.bool,
  /**
   * If `true`, expands the accordion, otherwise collapse it.
   * Setting this prop enables control over the accordion.
   */
  expanded: PropTypes.bool,
  /**
   * Callback fired when the expand/collapse state is changed.
   *
   * @param {React.SyntheticEvent} event The event source of the callback. **Warning**: This is a generic event not a change event.
   * @param {boolean} expanded The `expanded` state of the accordion.
   */
  onChange: PropTypes.func,
  /**
   * The props used for each slot inside.
   * @default {}
   */
  slotProps: PropTypes.shape({
    root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
  }),
  /**
   * The components used for each slot inside.
   * @default {}
   */
  slots: PropTypes.shape({
    root: PropTypes.elementType
  }),
  /**
   * The system prop that allows defining system overrides as well as additional CSS styles.
   */
  sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
  /**
   * The [global variant](https://mui.com/joy-ui/main-features/global-variants/) to use.
   * @default 'plain'
   */
  variant: PropTypes.oneOf(['outlined', 'plain', 'soft', 'solid'])
} : void 0;
export default Accordion;