'use client';

import _extends from "@babel/runtime/helpers/esm/extends";
import _objectWithoutPropertiesLoose from "@babel/runtime/helpers/esm/objectWithoutPropertiesLoose";
const _excluded = ["anchorEl", "direction", "disablePortal", "keepMounted", "modifiers", "open", "placement", "popperOptions", "popperRef", "TransitionProps"],
  _excluded2 = ["children", "className", "component", "color", "variant", "size", "slots", "slotProps"];
import * as React from 'react';
import clsx from 'clsx';
import PropTypes from 'prop-types';
import { unstable_capitalize as capitalize } from '@mui/utils';
import { unstable_composeClasses as composeClasses } from '@mui/base/composeClasses';
import { StyledList } from '../List/List';
import { styled, useThemeProps } from '../styles';
import { VariantColorProvider } from '../styles/variantColorInheritance';
import { getAutocompleteListboxUtilityClass } from './autocompleteListboxClasses';
import listItemClasses from '../ListItem/listItemClasses';
import listClasses from '../List/listClasses';
import { scopedVariables } from '../List/ListProvider';
import useSlot from '../utils/useSlot';
import { jsx as _jsx } from "react/jsx-runtime";
const useUtilityClasses = ownerState => {
  const {
    variant,
    color,
    size
  } = ownerState;
  const slots = {
    root: ['root', variant && `variant${capitalize(variant)}`, color && `color${capitalize(color)}`, size && `size${capitalize(size)}`]
  };
  return composeClasses(slots, getAutocompleteListboxUtilityClass, {});
};
const excludePopperProps = _ref => {
  let other = _objectWithoutPropertiesLoose(_ref, _excluded);
  return other;
};
export const StyledAutocompleteListbox = styled(StyledList)(({
  theme,
  ownerState
}) => {
  var _theme$variants;
  const variantStyle = (_theme$variants = theme.variants[ownerState.variant]) == null ? void 0 : _theme$variants[ownerState.color];
  return _extends({
    '--focus-outline-offset': `calc(${theme.vars.focus.thickness} * -1)`,
    // to prevent the focus outline from being cut by overflow
    '--ListItem-stickyBackground': (variantStyle == null ? void 0 : variantStyle.backgroundColor) || (variantStyle == null ? void 0 : variantStyle.background) || theme.vars.palette.background.popup,
    '--ListItem-stickyTop': 'calc(var(--List-padding, var(--ListDivider-gap)) * -1)'
  }, scopedVariables, {
    boxShadow: theme.shadow.md,
    borderRadius: `var(--List-radius, ${theme.vars.radius.sm})`
  }, !(variantStyle != null && variantStyle.backgroundColor) && {
    backgroundColor: theme.vars.palette.background.popup
  }, {
    zIndex: theme.vars.zIndex.popup,
    overflow: 'auto',
    maxHeight: '40vh',
    position: 'relative',
    // to make sure that the listbox is positioned for grouped options to work.
    '&:empty': {
      visibility: 'hidden'
    },
    [`& .${listItemClasses.nested}, & .${listItemClasses.nested} .${listClasses.root}`]: {
      // For grouped options autocomplete:
      // Force the position to make the scroll into view logic works because the `element.offsetTop` should reference to the listbox, not the grouped list.
      // See the implementation of the `useAutocomplete` line:370
      //
      // Resource: https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetTop
      position: 'initial'
    }
  });
});
const AutocompleteListboxRoot = styled(StyledAutocompleteListbox, {
  name: 'JoyAutocompleteListbox',
  slot: 'Root',
  overridesResolver: (props, styles) => styles.root
})({});
/**
 *
 * Demos:
 *
 * - [Autocomplete](https://mui.com/joy-ui/react-autocomplete/)
 *
 * API:
 *
 * - [AutocompleteListbox API](https://mui.com/joy-ui/api/autocomplete-listbox/)
 */
const AutocompleteListbox = /*#__PURE__*/React.forwardRef(function AutocompleteListbox(inProps, ref) {
  const props = useThemeProps({
    props: inProps,
    name: 'JoyAutocompleteListbox'
  });
  const {
      children,
      className,
      component,
      color = 'neutral',
      variant = 'outlined',
      size = 'md',
      slots = {},
      slotProps = {}
    } = props,
    otherProps = _objectWithoutPropertiesLoose(props, _excluded2);
  const ownerState = _extends({}, props, {
    size,
    color,
    variant,
    nesting: false,
    row: false,
    wrap: false
  });
  const other = excludePopperProps(otherProps);
  const classes = useUtilityClasses(ownerState);
  const externalForwardedProps = _extends({}, other, {
    component,
    slots,
    slotProps
  });
  const [SlotRoot, rootProps] = useSlot('root', {
    ref,
    className: clsx(classes.root, className),
    elementType: AutocompleteListboxRoot,
    externalForwardedProps,
    ownerState,
    additionalProps: {
      role: 'listbox'
    }
  });
  return /*#__PURE__*/_jsx(VariantColorProvider, {
    variant: variant,
    color: color,
    children: /*#__PURE__*/_jsx(SlotRoot, _extends({}, rootProps, {
      children: children
    }))
  });
});
process.env.NODE_ENV !== "production" ? AutocompleteListbox.propTypes /* remove-proptypes */ = {
  // ┌────────────────────────────── Warning ──────────────────────────────┐
  // │ These PropTypes are generated from the TypeScript type definitions. │
  // │ To update them, edit the TypeScript types and run `pnpm proptypes`. │
  // └─────────────────────────────────────────────────────────────────────┘
  /**
   * @ignore
   */
  children: PropTypes.node,
  /**
   * @ignore
   */
  className: PropTypes.string,
  /**
   * The color of the component. It supports those theme colors that make sense for this component.
   * @default 'neutral'
   */
  color: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['danger', 'neutral', 'primary', 'success', 'warning']), PropTypes.string]),
  /**
   * The component used for the root node.
   * Either a string to use a HTML element or a component.
   */
  component: PropTypes.elementType,
  /**
   * The size of the component (affect other nested list* components).
   * @default 'md'
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg']),
  /**
   * The props used for each slot inside.
   * @default {}
   */
  slotProps: PropTypes.shape({
    root: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
  }),
  /**
   * The components used for each slot inside.
   * @default {}
   */
  slots: PropTypes.shape({
    root: PropTypes.elementType
  }),
  /**
   * The system prop that allows defining system overrides as well as additional CSS styles.
   */
  sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object]),
  /**
   * The [global variant](https://mui.com/joy-ui/main-features/global-variants/) to use.
   * @default 'outlined'
   */
  variant: PropTypes /* @typescript-to-proptypes-ignore */.oneOfType([PropTypes.oneOf(['contained', 'light', 'outlined', 'text']), PropTypes.string])
} : void 0;
export default AutocompleteListbox;