import * as React from 'react';
import { OverridableStringUnion, OverrideProps } from '@mui/types';
import { ColorPaletteProp, SxProps, VariantProp, ApplyColorInversion } from '../styles/types';
import { SlotProps, CreateSlotsAndSlotProps } from '../utils/types';
export type AccordionSlot = 'root';
export interface AccordionSlots {
    /**
     * The component that renders the root.
     * @default 'div'
     */
    root?: React.ElementType;
}
export type AccordionSlotsAndSlotProps = CreateSlotsAndSlotProps<AccordionSlots, {
    root: SlotProps<'div', {}, AccordionOwnerState>;
}>;
export interface AccordionPropsVariantOverrides {
}
export interface AccordionPropsColorOverrides {
}
export interface AccordionTypeMap<ExtraProps = {}, Tag extends React.ElementType = 'div'> {
    props: ExtraProps & {
        /**
         * The id to be used in the AccordionDetails which is controlled by the AccordionSummary.
         * If not provided, the id is autogenerated.
         */
        accordionId?: string;
        /**
         * The color of the component. It supports those theme colors that make sense for this component.
         * @default 'neutral'
         */
        color?: OverridableStringUnion<ColorPaletteProp, AccordionPropsColorOverrides>;
        /**
         * Used to render icon or text elements inside the Accordion if `src` is not set.
         * This can be an element, or just a string.
         */
        children?: React.ReactNode;
        /**
         * If `true`, expands the accordion by default.
         * @default false
         */
        defaultExpanded?: boolean;
        /**
         * If `true`, the component is disabled.
         * @default false
         */
        disabled?: boolean;
        /**
         * If `true`, expands the accordion, otherwise collapse it.
         * Setting this prop enables control over the accordion.
         */
        expanded?: boolean;
        /**
         * Callback fired when the expand/collapse state is changed.
         *
         * @param {React.SyntheticEvent} event The event source of the callback. **Warning**: This is a generic event not a change event.
         * @param {boolean} expanded The `expanded` state of the accordion.
         */
        onChange?: (event: React.SyntheticEvent, expanded: boolean) => void;
        /**
         * The [global variant](https://mui.com/joy-ui/main-features/global-variants/) to use.
         * @default 'plain'
         */
        variant?: OverridableStringUnion<VariantProp, AccordionPropsVariantOverrides>;
        /**
         * The system prop that allows defining system overrides as well as additional CSS styles.
         */
        sx?: SxProps;
    } & AccordionSlotsAndSlotProps;
    defaultComponent: Tag;
}
export type AccordionProps<Tag extends React.ElementType = AccordionTypeMap['defaultComponent'], ExtraProps = {
    component?: React.ElementType;
}> = OverrideProps<AccordionTypeMap<ExtraProps, Tag>, Tag>;
export interface AccordionOwnerState extends ApplyColorInversion<AccordionProps> {
}
