<?php

namespace App\Services;

class TranslationService
{
    /**
     * Get dynamic translation from a JSON column of a model.
     *
     * @param string $model Fully-qualified model class name
     * @param string $column     Column name containing JSON translations
     * @param int    $id         Record ID
     * @param string $language   Language key (e.g., 'en', 'fr')
     * @return string|null
     */
    public function getDynamicTranslation($model, $column, $id, $language)
    {
        if (!class_exists($model)) {
            return null;
        }

        $record = $model::find($id);

        if (!$record) {
            return null;
        }

        $rawData = $record->$column;
        $translations = json_decode($rawData, true);

        // If it's not JSON (e.g. encoded as a plain string in DB), return the raw data
        if (json_last_error() !== JSON_ERROR_NONE || !is_array($translations)) {
            return $rawData;
        }

        if (isset($translations[$language]) && !empty($translations[$language])) {
            return $translations[$language];
        }

        if (isset($translations['en']) && !empty($translations['en'])) {
            return $translations['en'];
        }

        // Fallback to the original column value if no translation found
        return $rawData;
    }

    public function getLanguageCode()
    {
        return session()->get('locale', 'en');
    }

}
