<?php

namespace App\Models;

use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class Deliveryboy extends Model implements HasMedia
{
    use InteractsWithMedia;
    use HasApiTokens, HasFactory, Notifiable;

    protected $table = 'users';

    protected $fillable = [
        'username',
        'mobile',
        'email',
        'password',
        'address',
        'bonus_type',
        'bonus',
        'front_licence_image',
        'back_licence_image',
        'serviceable_zones',
        'role_id',
        'active',
        'disk',
    ];

    public function registerMediaCollections(): void
    {
        $media_storage_settings = fetchDetails(StorageType::class, ['is_default' => 1], '*');
        $mediaStorageType = !$media_storage_settings->isEmpty() ? $media_storage_settings[0]->name : 'public';
        if ($mediaStorageType === 's3') {
            $this->addMediaCollection('delivery_boys')->useDisk('s3');
        } else {
            $this->addMediaCollection('delivery_boys')->useDisk('public');
        }
    }
}
