<?php

namespace App\Livewire\Products;

use App\Models\Product;
use App\Models\ProductRating;
use App\Models\User;
use Livewire\Component;

class Reviews extends Component
{
    public $product_id = "";
    public function mount($slug)
    {
        $product_id = fetchDetails(Product::class, ['slug' => $slug], 'id');
        $this->product_id = $product_id[0]->id;
    }

    public function render()
    {
        $reviews = fetchDetails(ProductRating::class, ['product_id' => $this->product_id]);
        foreach ($reviews as $key => $ratings) {
            $user_info = fetchDetails(User::class, ['id' => $ratings->user_id], ['image', 'username']);
            $reviews[$key]->user_profile = (!empty($user_info) && isset($user_info[0]->image)) ? $user_info[0]->image : "frontend/elegant/user-profile-icon.jpg";
            $reviews[$key]->user_name = (!empty($user_info) && isset($user_info[0]->username)) ? $user_info[0]->username : "";
        }
        return view('livewire.' . config('constants.theme') . '.products.reviews', [
            'customer_reviews' => $reviews
        ]);
    }
}
