<?php

namespace App\Livewire\Products;

use App\Models\City;
use App\Models\Product;
use App\Models\Zipcode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Livewire\Component;
use Livewire\WithFileUploads;
use App\Services\ProductService;
use App\Services\DeliveryService;
use App\Services\StoreService;
use App\Services\TranslationService;

class Details extends Component
{
    use WithFileUploads;

    protected $listeners = ['local_cart_data', 'city'];

    public $store_id;
    public $user_id;
    public function __construct()
    {
        $this->user_id = Auth::user() != '' ? Auth::user()->id : NUll;
    }

    public $product_details;

    public $product_id = "";

    public $pname = "";

    public $pdescription = "";
    public $image = "";

    public $pincode = "";
    public $city = "";

    public $relative_products = [];

    public function mount($slug)
    {
        $filter['slug'] = $slug;
        $user_id = $this->user_id;
        $this->store_id = session('store_id');
        $store_id = $this->store_id;

        $details = app(ProductService::class)->fetchProduct(user_id: $user_id, filter: $filter, is_detailed_data: 1, store_id: $store_id);

        // Check if product data is valid
        if (!isset($details['product']) || !is_array($details['product']) || empty($details['product'])) {
            $this->redirect('products', true);
            return;
        }

        $this->product_id = $details['product'][0]['id'] ?? null;
        if (!$this->product_id) {
            $this->redirect('products', true);
            return;
        }

        $product_ids = [$this->product_id];
        if (count($product_ids) >= 1) {
            $category_id = fetchDetails(Product::class, ['id' => $this->product_id], '*');
            $categories_id = $category_id[0]->category_id ?? "";
            $brand_id = $category_id[0]->brand ?? "";
            $tags = $category_id[0]->tags ?? "";

            $relative_products_id = Product::where('store_id', $store_id)
                ->where(function ($query) use ($categories_id, $brand_id) {
                    $query->where('category_id', $categories_id)
                        ->orWhere('brand', $brand_id);
                })
                ->whereNotIn('id', $product_ids)
                ->select('id')
                ->limit(10)
                ->get();

            $relative_id = $relative_products_id->pluck('id')->toArray();
            $relative_product = app(ProductService::class)->fetchProduct($user_id, "", $relative_id);
            $this->relative_products = $relative_product['product'] ?? [];
        }

        $this->product_details = (object) ($details['product'][0] ?? []);
        $this->pname = $details['product'][0]['name'] ?? '';
        $this->pdescription = $details['product'][0]['short_description'] ?? '';
        $this->image = $details['product'][0]['image'] ?? '';
    }
    public function render()
    {
        $product_id = $this->product_id;

        $store_id = $this->store_id;

        $deliverabilitySettings = app(DeliveryService::class)->getDeliveryChargeSetting($store_id);

        if ($product_id != "") {
            $siblingsProduct = getPreviousAndNextItemWithId(Product::class, $product_id, $store_id);
            $bread_crumb = [
                'page_main_bread_crumb' => '<a wire:navigate href="' . customUrl('products') . '">' . labels('front_messages.products', 'Products') . '</a>',
                'right_breadcrumb' => array(
                    '<a wire:navigate href="' . customUrl('products/' . $this->product_details->slug) . '">' . $this->pname . '</a>'
                )
            ];
        }
        $store_settings = app(StoreService::class)->getStoreSettings();
        $details_style = getProductDetailsStyle($store_settings);
        $language_code = app(TranslationService::class)->getLanguageCode();
        // dd($details_style);
        return view($details_style, [
            'product_details' => $this->product_details,
            'relative_products' => $this->relative_products,
            'siblingsProduct' => $siblingsProduct,
            'product_id' => $product_id,
            'bread_crumb' => $bread_crumb,
            'deliverabilitySettings' => $deliverabilitySettings,
            'language_code' => $language_code,
        ])->layoutData([
            'title' => $this->pname . " |",
            'metaKeys' =>  $this->pname,
            'metaDescription' =>  $this->pdescription,
            'metaImage' => $this->image
        ]);
    }

    public function city($city)
    {
        $this->city = $city;
    }

    // public function check_product_deliverability(Request $request)
    // {
    //     $store_id = session('store_id');
    //     $deliverabilitySettings = app(DeliveryService::class)->getDeliveryChargeSetting($store_id);
    //     $validator = Validator::make(
    //         $request->all(),
    //         [
    //             'product_type' => 'required',
    //             'product_id' => 'required|exists:products,id'
    //         ]
    //     );

    //     if ($deliverabilitySettings[0]->product_deliverability_type == 'city_wise_deliverability') {
    //         $validator = Validator::make(
    //             $request->all(),
    //             [
    //                 'city' => 'required'
    //             ]
    //         );
    //         $request['pincode'] = null;
    //     } else {
    //         $validator = Validator::make(
    //             $request->all(),
    //             [
    //                 'pincode' => 'required'
    //             ]
    //         );
    //         $request['city'] = null;
    //     }
    //     if ($validator->fails()) {
    //         $errors = $validator->errors();
    //         $response['error'] = true;
    //         $response['message'] = $errors;
    //         return $response;
    //     }
    //     $pincode = $request['pincode'];
    //     $city = $request['city'];
    //     $city_id = "";
    //     $pincode_id = "";
    //     if ($deliverabilitySettings[0]->product_deliverability_type == 'city_wise_deliverability') {
    //         $city_id = fetchDetails(City::class, ['name->en' => $city]);
    //         if ($city_id != []) {
    //             $city_id = $city_id[0]->id;
    //         }
    //     } else {
    //         $pincode_id = fetchDetails(Zipcode::class, ['zipcode' => $pincode]);
    //         if ($pincode_id != []) {
    //             $pincode_id = $pincode_id[0]->id;
    //         }
    //     }
    //     $product_id = $request['product_id'];
    //     $product_type = $request['product_type'];
    //     return app(DeliveryService::class)->checkProductDeliverable(product_id: $product_id, store_id: $store_id, city_id: $city_id, zipcode_id: $pincode_id, zipcode: $pincode, product_type: $product_type);
    // }
    public function check_product_deliverability(Request $request)
{
    $store_id = session('store_id');
    $settings = app(DeliveryService::class)->getDeliveryChargeSetting($store_id);

    Validator::make($request->all(), [
        'product_id' => 'required',
        'product_type' => 'required'
    ])->validate();

    if ($settings[0]->product_deliverability_type === 'city_wise_deliverability') {
        Validator::make($request->all(), [
            'city' => 'required'
        ])->validate();
        $request['pincode'] = null;
    } else {
        Validator::make($request->all(), [
            'pincode' => 'required'
        ])->validate();
        $request['city'] = null;
    }

    $city_id = $pincode_id = null;

    if ($settings[0]->product_deliverability_type === 'city_wise_deliverability') {
        $cityRow = City::whereRaw('LOWER(name) = ?', [strtolower($request->city)])->first();
        $city_id = $cityRow?->id;
    } else {
        $zipRow = Zipcode::where('zipcode', $request->pincode)->first();
        $pincode_id = $zipRow?->id;
    }

    $isDeliverable = app(DeliveryService::class)->checkProductDeliverable(
        product_id: $request->product_id,
        store_id: $store_id,
        city_id: $city_id,
        zipcode_id: $pincode_id,
        zipcode: $request->pincode,
        product_type: $request->product_type
    );
   
    
    return response()->json([
        'error' => false,
        'is_deliverable' => (bool) $isDeliverable
    ]);
}

}
