<?php

namespace App\Livewire\Payments;

use App\Libraries\Phonepe;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Status extends Component
{
    public $id;
    public $response;
    public $payment_response;

    public function mount()
    {
        // Fetch from query params manually
        $this->id = request()->query('id');
        $this->response = request()->query('response');

        \Log::info('Mount Params', ['id' => $this->id, 'response' => $this->response]);

        $this->payment_response = $this->handlePaymentResponse();
    }

    public function handlePaymentResponse()
    {
        if (in_array($this->response, ['wallet_success', 'wallet_failed', 'order_success', 'order_failed'])) {
            return $this->response;
        }

        if (!$this->id || $this->id == 'null') {
            \Log::warning('Payment response called without ID.');
            return 'order_failed';
        }

        $phonepe = new Phonepe();
        $check_status = $phonepe->check_status_v2($this->id);

        $transaction = fetchDetails(Transaction::class, ['txn_id' => $this->id]);

        if (!empty($transaction)) {
            if ($transaction[0]->type == "phonepe") {
                Auth::loginUsingId($transaction[0]->user_id);
            }

            $status = $check_status['state'] ?? 'PAYMENT_FAILED';

            if (in_array($status, ['PAYMENT_SUCCESS', 'INTERNAL_SERVER_ERROR', 'COMPLETED'])) {
                return $transaction[0]->transaction_type === 'wallet' ? 'wallet_success' : 'order_success';
            } else {
                return $transaction[0]->transaction_type === 'wallet' ? 'wallet_failed' : 'order_failed';
            }
        }

        return 'order_failed';
    }

    public function render()
    {
        return view('livewire.' . config('constants.theme') . '.payments.status', [
            'breadcrumb' => 'Payment Status',
            'payment_response' => $this->payment_response,
        ])->title("Payment Status |");
    }
}
